/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.user;

import java.util.Arrays;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;

public class UserQuery {
    public static final UserQuery ALL_ACTIVES = UserQuery.builder().build();
    private final Collection<String> logins;
    private final boolean includeDeactivated;
    private final String searchText;
    private final Boolean mustBeRoot;
    final String searchTextSql;

    private UserQuery(Builder builder) {
        this.logins = builder.logins;
        this.includeDeactivated = builder.includeDeactivated;
        this.searchText = builder.searchText;
        this.mustBeRoot = builder.mustBeRoot;
        this.searchTextSql = UserQuery.searchTextToSql(this.searchText);
    }

    private static String searchTextToSql(@Nullable String s) {
        String sql = null;
        if (s != null) {
            sql = StringUtils.replace(s, "%", "/%");
            sql = StringUtils.replace(sql, "_", "/_");
            sql = "%" + sql + "%";
        }
        return sql;
    }

    @CheckForNull
    public Collection<String> logins() {
        return this.logins;
    }

    public boolean includeDeactivated() {
        return this.includeDeactivated;
    }

    @CheckForNull
    public String searchText() {
        return this.searchText;
    }

    @CheckForNull
    public Boolean mustBeRoot() {
        return this.mustBeRoot;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean includeDeactivated = false;
        private Collection<String> logins;
        private String searchText;
        private Boolean mustBeRoot;

        private Builder() {
        }

        public Builder includeDeactivated() {
            this.includeDeactivated = true;
            return this;
        }

        public Builder logins(@Nullable Collection<String> logins) {
            this.logins = logins;
            return this;
        }

        public Builder logins(String ... logins) {
            this.logins = Arrays.asList(logins);
            return this;
        }

        public Builder searchText(@Nullable String s) {
            this.searchText = StringUtils.defaultIfBlank(s, null);
            return this;
        }

        public Builder mustBeRoot() {
            this.mustBeRoot = true;
            return this;
        }

        public Builder mustNotBeRoot() {
            this.mustBeRoot = false;
            return this;
        }

        public UserQuery build() {
            if (this.logins != null && this.logins.size() >= 1000) {
                throw new IllegalArgumentException("Max number of logins is 1000. Got " + this.logins.size());
            }
            return new UserQuery(this);
        }
    }
}

