/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.detector;

import java.util.Comparator;
import org.sonar.duplications.index.ClonePart;
import org.sonar.duplications.utils.FastStringComparator;

public final class ContainsInComparator
implements Comparator<ClonePart> {
    public static final Comparator<ClonePart> RESOURCE_ID_COMPARATOR = new Comparator<ClonePart>(){

        @Override
        public int compare(ClonePart o1, ClonePart o2) {
            return FastStringComparator.INSTANCE.compare(o1.getResourceId(), o2.getResourceId());
        }
    };
    public static final Comparator<ClonePart> CLONEPART_COMPARATOR = new Comparator<ClonePart>(){

        @Override
        public int compare(ClonePart o1, ClonePart o2) {
            int c = RESOURCE_ID_COMPARATOR.compare(o1, o2);
            if (c == 0) {
                return o1.getUnitStart() - o2.getUnitStart();
            }
            return c;
        }
    };
    private final int l1;
    private final int l2;

    public ContainsInComparator(int l1, int l2) {
        this.l1 = l1;
        this.l2 = l2;
    }

    @Override
    public int compare(ClonePart part1, ClonePart part2) {
        int c = RESOURCE_ID_COMPARATOR.compare(part1, part2);
        if (c == 0) {
            if (part1.getUnitStart() <= part2.getUnitStart()) {
                if (part2.getUnitStart() + this.l2 <= part1.getUnitStart() + this.l1) {
                    return 0;
                }
                return -1;
            }
            return 1;
        }
        return c;
    }
}

