/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.ExternalIssue;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.internal.AbstractDefaultIssue;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.rules.RuleType;

public class DefaultExternalIssue
extends AbstractDefaultIssue<DefaultExternalIssue>
implements ExternalIssue,
NewExternalIssue {
    private Long effort;
    private Severity severity;
    private RuleType type;

    public DefaultExternalIssue() {
        super(null);
    }

    public DefaultExternalIssue(@Nullable SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultExternalIssue remediationEffortMinutes(@Nullable Long effort) {
        Preconditions.checkArgument(effort == null || effort >= 0L, String.format("effort must be greater than or equal 0 (got %s)", effort));
        this.effort = effort;
        return this;
    }

    @Override
    public DefaultExternalIssue severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public Severity severity() {
        return this.severity;
    }

    @Override
    public Long remediationEffort() {
        return this.effort;
    }

    @Override
    public void doSave() {
        Objects.requireNonNull(this.ruleKey, "Rule key is mandatory on external issue");
        Preconditions.checkState(this.primaryLocation != null, "Primary location is mandatory on every external issue");
        Preconditions.checkState(this.primaryLocation.inputComponent().isFile(), "External issues must be located in files");
        Preconditions.checkState(this.primaryLocation.message() != null, "External issues must have a message");
        Preconditions.checkState(this.severity != null, "Severity is mandatory on every external issue");
        Preconditions.checkState(this.type != null, "Type is mandatory on every external issue");
        this.storage.store(this);
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    @Override
    public DefaultExternalIssue type(RuleType type) {
        this.type = type;
        return this;
    }
}

