/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.internal.AbstractDefaultIssue;
import org.sonar.api.internal.google.common.base.Preconditions;

public class DefaultIssue
extends AbstractDefaultIssue<DefaultIssue>
implements Issue,
NewIssue {
    private Double gap;
    private Severity overriddenSeverity;

    public DefaultIssue() {
        super(null);
    }

    public DefaultIssue(@Nullable SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultIssue effortToFix(@Nullable Double effortToFix) {
        return this.gap(effortToFix);
    }

    @Override
    public DefaultIssue gap(@Nullable Double gap) {
        Preconditions.checkArgument(gap == null || gap >= 0.0, String.format("Gap must be greater than or equal 0 (got %s)", gap));
        this.gap = gap;
        return this;
    }

    @Override
    public DefaultIssue overrideSeverity(@Nullable Severity severity) {
        this.overriddenSeverity = severity;
        return this;
    }

    @Override
    public Severity overriddenSeverity() {
        return this.overriddenSeverity;
    }

    @Override
    public Double gap() {
        return this.gap;
    }

    @Override
    public Double effortToFix() {
        return this.gap;
    }

    @Override
    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    @Override
    public void doSave() {
        Objects.requireNonNull(this.ruleKey, "ruleKey is mandatory on issue");
        Preconditions.checkState(this.primaryLocation != null, "Primary location is mandatory on every issue");
        this.storage.store(this);
    }
}

