/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultIndexedFile;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.DefaultTextPointer;
import org.sonar.api.batch.fs.internal.DefaultTextRange;
import org.sonar.api.batch.fs.internal.Metadata;
import org.sonar.api.internal.apachecommons.io.ByteOrderMark;
import org.sonar.api.internal.apachecommons.io.input.BOMInputStream;
import org.sonar.api.internal.google.common.base.Preconditions;

public class DefaultInputFile
extends DefaultInputComponent
implements InputFile {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final DefaultIndexedFile indexedFile;
    private final String contents;
    private final Consumer<DefaultInputFile> metadataGenerator;
    private InputFile.Status status;
    private Charset charset;
    private Metadata metadata;
    private boolean published;
    private boolean excludedForCoverage;

    public DefaultInputFile(DefaultIndexedFile indexedFile, Consumer<DefaultInputFile> metadataGenerator) {
        this(indexedFile, metadataGenerator, null);
    }

    public DefaultInputFile(DefaultIndexedFile indexedFile, Consumer<DefaultInputFile> metadataGenerator, @Nullable String contents) {
        super(indexedFile.batchId());
        this.indexedFile = indexedFile;
        this.metadataGenerator = metadataGenerator;
        this.metadata = null;
        this.published = false;
        this.excludedForCoverage = false;
        this.contents = contents;
    }

    public void checkMetadata() {
        if (this.metadata == null) {
            this.metadataGenerator.accept(this);
        }
    }

    @Override
    public InputStream inputStream() throws IOException {
        return this.contents != null ? new ByteArrayInputStream(this.contents.getBytes(this.charset())) : new BOMInputStream(Files.newInputStream(this.path(), new OpenOption[0]), ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE);
    }

    @Override
    public String contents() throws IOException {
        if (this.contents != null) {
            return this.contents;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (InputStream inputStream = this.inputStream();){
            int length;
            byte[] buffer = new byte[4096];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
        }
        return result.toString(this.charset().name());
    }

    public DefaultInputFile setPublished(boolean published) {
        this.published = published;
        return this;
    }

    public boolean isPublished() {
        return this.published;
    }

    public DefaultInputFile setExcludedForCoverage(boolean excludedForCoverage) {
        this.excludedForCoverage = excludedForCoverage;
        return this;
    }

    public boolean isExcludedForCoverage() {
        return this.excludedForCoverage;
    }

    @Override
    @Deprecated
    public String relativePath() {
        return this.indexedFile.relativePath();
    }

    public String getModuleRelativePath() {
        return this.indexedFile.getModuleRelativePath();
    }

    public String getProjectRelativePath() {
        return this.indexedFile.getProjectRelativePath();
    }

    @Override
    public String absolutePath() {
        return this.indexedFile.absolutePath();
    }

    @Override
    public File file() {
        return this.indexedFile.file();
    }

    @Override
    public Path path() {
        return this.indexedFile.path();
    }

    @Override
    @CheckForNull
    public String language() {
        return this.indexedFile.language();
    }

    @Override
    public InputFile.Type type() {
        return this.indexedFile.type();
    }

    @Override
    public String key() {
        return this.indexedFile.key();
    }

    public String moduleKey() {
        return this.indexedFile.moduleKey();
    }

    @Override
    public int hashCode() {
        return this.indexedFile.hashCode();
    }

    @Override
    public String toString() {
        return this.indexedFile.toString();
    }

    @Override
    public InputFile.Status status() {
        this.checkMetadata();
        return this.status;
    }

    @Override
    public int lines() {
        this.checkMetadata();
        return this.metadata.lines();
    }

    @Override
    public boolean isEmpty() {
        this.checkMetadata();
        return this.metadata.isEmpty();
    }

    @Override
    public Charset charset() {
        this.checkMetadata();
        return this.charset;
    }

    public int lastValidOffset() {
        this.checkMetadata();
        return this.metadata.lastValidOffset();
    }

    public String hash() {
        this.checkMetadata();
        return this.metadata.hash();
    }

    public int nonBlankLines() {
        this.checkMetadata();
        return this.metadata.nonBlankLines();
    }

    public int[] originalLineStartOffsets() {
        this.checkMetadata();
        Preconditions.checkState(this.metadata.originalLineStartOffsets() != null, "InputFile is not properly initialized.");
        Preconditions.checkState(this.metadata.originalLineStartOffsets().length == this.metadata.lines(), "InputFile is not properly initialized. 'originalLineStartOffsets' property length should be equal to 'lines'");
        return this.metadata.originalLineStartOffsets();
    }

    public int[] originalLineEndOffsets() {
        this.checkMetadata();
        Preconditions.checkState(this.metadata.originalLineEndOffsets() != null, "InputFile is not properly initialized.");
        Preconditions.checkState(this.metadata.originalLineEndOffsets().length == this.metadata.lines(), "InputFile is not properly initialized. 'originalLineEndOffsets' property length should be equal to 'lines'");
        return this.metadata.originalLineEndOffsets();
    }

    @Override
    public TextPointer newPointer(int line, int lineOffset) {
        this.checkMetadata();
        DefaultTextPointer textPointer = new DefaultTextPointer(line, lineOffset);
        this.checkValid(textPointer, "pointer");
        return textPointer;
    }

    @Override
    public TextRange newRange(TextPointer start, TextPointer end) {
        this.checkMetadata();
        this.checkValid(start, "start pointer");
        this.checkValid(end, "end pointer");
        return DefaultInputFile.newRangeValidPointers(start, end, false);
    }

    @Override
    public TextRange newRange(int startLine, int startLineOffset, int endLine, int endLineOffset) {
        this.checkMetadata();
        TextPointer start = this.newPointer(startLine, startLineOffset);
        TextPointer end = this.newPointer(endLine, endLineOffset);
        return DefaultInputFile.newRangeValidPointers(start, end, false);
    }

    @Override
    public TextRange selectLine(int line) {
        this.checkMetadata();
        TextPointer startPointer = this.newPointer(line, 0);
        TextPointer endPointer = this.newPointer(line, this.lineLength(line));
        return DefaultInputFile.newRangeValidPointers(startPointer, endPointer, true);
    }

    public void validate(TextRange range) {
        this.checkMetadata();
        this.checkValid(range.start(), "start pointer");
        this.checkValid(range.end(), "end pointer");
    }

    public TextRange newRange(int startOffset, int endOffset) {
        this.checkMetadata();
        return DefaultInputFile.newRangeValidPointers(this.newPointer(startOffset), this.newPointer(endOffset), false);
    }

    public TextPointer newPointer(int globalOffset) {
        this.checkMetadata();
        Preconditions.checkArgument(globalOffset >= 0, "%s is not a valid offset for a file", globalOffset);
        Preconditions.checkArgument(globalOffset <= this.lastValidOffset(), "%s is not a valid offset for file %s. Max offset is %s", globalOffset, this, this.lastValidOffset());
        int line = this.findLine(globalOffset);
        int startLineOffset = this.originalLineStartOffsets()[line - 1];
        return new DefaultTextPointer(line, Math.min(globalOffset, this.originalLineEndOffsets()[line - 1]) - startLineOffset);
    }

    public DefaultInputFile setStatus(InputFile.Status status) {
        this.status = status;
        return this;
    }

    public DefaultInputFile setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    private void checkValid(TextPointer pointer, String owner) {
        Preconditions.checkArgument(pointer.line() >= 1, "%s is not a valid line for a file", pointer.line());
        Preconditions.checkArgument(pointer.line() <= this.metadata.lines(), "%s is not a valid line for %s. File %s has %s line(s)", pointer.line(), owner, this, this.metadata.lines());
        Preconditions.checkArgument(pointer.lineOffset() >= 0, "%s is not a valid line offset for a file", pointer.lineOffset());
        int lineLength = this.lineLength(pointer.line());
        Preconditions.checkArgument(pointer.lineOffset() <= lineLength, "%s is not a valid line offset for %s. File %s has %s character(s) at line %s", pointer.lineOffset(), owner, this, lineLength, pointer.line());
    }

    private int lineLength(int line) {
        return this.originalLineEndOffsets()[line - 1] - this.originalLineStartOffsets()[line - 1];
    }

    private static TextRange newRangeValidPointers(TextPointer start, TextPointer end, boolean acceptEmptyRange) {
        Preconditions.checkArgument(acceptEmptyRange ? start.compareTo(end) <= 0 : start.compareTo(end) < 0, "Start pointer %s should be before end pointer %s", start, end);
        return new DefaultTextRange(start, end);
    }

    private int findLine(int globalOffset) {
        return Math.abs(Arrays.binarySearch(this.originalLineStartOffsets(), globalOffset) + 1);
    }

    public DefaultInputFile setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultInputFile that = (DefaultInputFile)obj;
        return this.getProjectRelativePath().equals(that.getProjectRelativePath());
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public String filename() {
        return this.indexedFile.filename();
    }

    @Override
    public URI uri() {
        return this.indexedFile.uri();
    }
}

