/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.batch.rule.internal.DefaultRule;
import org.sonar.api.batch.rule.internal.NewRule;
import org.sonar.api.internal.google.common.collect.HashBasedTable;
import org.sonar.api.internal.google.common.collect.ImmutableListMultimap;
import org.sonar.api.internal.google.common.collect.ImmutableTable;
import org.sonar.api.internal.google.common.collect.Table;
import org.sonar.api.rule.RuleKey;

@Immutable
class DefaultRules
implements Rules {
    private final ImmutableListMultimap<String, Rule> rulesByRepository;
    private final ImmutableTable<String, String, List<Rule>> rulesByRepositoryAndInternalKey;
    private final Map<RuleKey, Rule> rulesByRuleKey;

    DefaultRules(Collection<NewRule> newRules) {
        HashMap<RuleKey, DefaultRule> rulesByRuleKeyBuilder = new HashMap<RuleKey, DefaultRule>();
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        HashBasedTable<String, String, List<Rule>> tableBuilder = HashBasedTable.create();
        for (NewRule newRule : newRules) {
            DefaultRule r = new DefaultRule(newRule);
            rulesByRuleKeyBuilder.put(r.key(), r);
            builder.put(r.key().repository(), r);
            DefaultRules.addToTable(tableBuilder, r);
        }
        this.rulesByRuleKey = Collections.unmodifiableMap(rulesByRuleKeyBuilder);
        this.rulesByRepository = builder.build();
        this.rulesByRepositoryAndInternalKey = ImmutableTable.copyOf(tableBuilder);
    }

    private static void addToTable(Table<String, String, List<Rule>> table, DefaultRule r) {
        if (r.internalKey() == null) {
            return;
        }
        List<Rule> ruleList = table.get(r.key().repository(), r.internalKey());
        if (ruleList == null) {
            ruleList = new LinkedList<Rule>();
        }
        ruleList.add(r);
        table.put(r.key().repository(), r.internalKey(), ruleList);
    }

    @Override
    public Rule find(RuleKey ruleKey) {
        return this.rulesByRuleKey.get(ruleKey);
    }

    @Override
    public Collection<Rule> findAll() {
        return this.rulesByRepository.values();
    }

    @Override
    public Collection<Rule> findByRepository(String repository) {
        return this.rulesByRepository.get((Object)repository);
    }

    @Override
    public Collection<Rule> findByInternalKey(String repository, String internalKey) {
        List<Rule> rules = (List<Rule>)this.rulesByRepositoryAndInternalKey.get(repository, internalKey);
        return rules != null ? rules : Collections.emptyList();
    }
}

