/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputDir;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssueLocation;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Strings;
import org.sonar.api.utils.PathUtils;

public abstract class AbstractDefaultIssue<T extends AbstractDefaultIssue>
extends DefaultStorable {
    protected IssueLocation primaryLocation;
    protected List<List<IssueLocation>> flows = new ArrayList<List<IssueLocation>>();
    protected DefaultInputProject project;

    protected AbstractDefaultIssue(DefaultInputProject project) {
        this(project, null);
    }

    public AbstractDefaultIssue(DefaultInputProject project, @Nullable SensorStorage storage) {
        super(storage);
        this.project = project;
    }

    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    public List<Issue.Flow> flows() {
        return this.flows.stream().map(l -> () -> Collections.unmodifiableList(new ArrayList(l))).collect(Collectors.toList());
    }

    public NewIssueLocation newLocation() {
        return new DefaultIssueLocation();
    }

    public T at(NewIssueLocation primaryLocation) {
        Preconditions.checkArgument(primaryLocation != null, "Cannot use a location that is null");
        Preconditions.checkState(this.primaryLocation == null, "at() already called");
        this.primaryLocation = this.rewriteLocation((DefaultIssueLocation)primaryLocation);
        Preconditions.checkArgument(this.primaryLocation.inputComponent() != null, "Cannot use a location with no input component");
        return (T)this;
    }

    public T addLocation(NewIssueLocation secondaryLocation) {
        this.flows.add(Collections.singletonList(this.rewriteLocation((DefaultIssueLocation)secondaryLocation)));
        return (T)this;
    }

    public T addFlow(Iterable<NewIssueLocation> locations) {
        ArrayList<DefaultIssueLocation> flowAsList = new ArrayList<DefaultIssueLocation>();
        for (NewIssueLocation issueLocation : locations) {
            flowAsList.add(this.rewriteLocation((DefaultIssueLocation)issueLocation));
        }
        this.flows.add(flowAsList);
        return (T)this;
    }

    private DefaultIssueLocation rewriteLocation(DefaultIssueLocation location) {
        InputComponent component = location.inputComponent();
        Optional<Object> dirOrModulePath = Optional.empty();
        if (component instanceof DefaultInputDir) {
            DefaultInputDir dirComponent = (DefaultInputDir)component;
            dirOrModulePath = Optional.of(this.project.getBaseDir().relativize(dirComponent.path()));
        } else if (component instanceof DefaultInputModule && !Objects.equals(this.project.key(), component.key())) {
            DefaultInputModule moduleComponent = (DefaultInputModule)component;
            dirOrModulePath = Optional.of(this.project.getBaseDir().relativize(moduleComponent.getBaseDir()));
        }
        if (dirOrModulePath.isPresent()) {
            String path = PathUtils.sanitize(((Path)dirOrModulePath.get()).toString());
            DefaultIssueLocation fixedLocation = new DefaultIssueLocation();
            fixedLocation.on(this.project);
            StringBuilder fullMessage = new StringBuilder();
            if (!Strings.isNullOrEmpty(path)) {
                fullMessage.append("[").append(path).append("] ");
            }
            fullMessage.append(location.message());
            fixedLocation.message(fullMessage.toString());
            return fixedLocation;
        }
        return location;
    }
}

