/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleScope;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.internal.DefaultNewRepository;
import org.sonar.api.server.rule.internal.DefaultRepository;
import org.sonar.api.utils.Preconditions;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ServerSide
@ComputeEngineSide
@SonarLintSide
@ExtensionPoint
public interface RulesDefinition {
    public void define(Context var1);

    @Immutable
    public static interface Param {
        public String key();

        public String name();

        @Nullable
        public String description();

        @Nullable
        public String defaultValue();

        public RuleParamType type();
    }

    public static abstract class NewParam {
        public abstract String key();

        public abstract NewParam setName(@Nullable String var1);

        public abstract NewParam setType(RuleParamType var1);

        public abstract NewParam setDescription(@Nullable String var1);

        public abstract NewParam setDefaultValue(@Nullable String var1);
    }

    @Immutable
    public static abstract class Rule {
        public abstract Repository repository();

        @CheckForNull
        public abstract String pluginKey();

        public abstract String key();

        public abstract String name();

        public abstract RuleScope scope();

        public abstract RuleType type();

        public abstract String severity();

        @CheckForNull
        public abstract String htmlDescription();

        @CheckForNull
        public abstract String markdownDescription();

        public abstract boolean template();

        public abstract boolean activatedByDefault();

        public abstract RuleStatus status();

        @CheckForNull
        @Deprecated
        public abstract String debtSubCharacteristic();

        @CheckForNull
        public abstract DebtRemediationFunction debtRemediationFunction();

        @Deprecated
        @CheckForNull
        public abstract String effortToFixDescription();

        @CheckForNull
        public abstract String gapDescription();

        @CheckForNull
        public abstract Param param(String var1);

        public abstract List<Param> params();

        public abstract Set<String> tags();

        public abstract Set<String> securityStandards();

        public abstract Set<RuleKey> deprecatedRuleKeys();

        @CheckForNull
        public abstract String internalKey();
    }

    public static abstract class NewRule {
        public abstract String key();

        @CheckForNull
        public abstract RuleScope scope();

        public abstract NewRule setScope(RuleScope var1);

        public abstract NewRule setName(String var1);

        public abstract NewRule setTemplate(boolean var1);

        public abstract NewRule setActivatedByDefault(boolean var1);

        public abstract NewRule setSeverity(String var1);

        public abstract NewRule setType(RuleType var1);

        public abstract NewRule setHtmlDescription(@Nullable String var1);

        public abstract NewRule setHtmlDescription(@Nullable URL var1);

        public abstract NewRule setMarkdownDescription(@Nullable String var1);

        public abstract NewRule setMarkdownDescription(@Nullable URL var1);

        public abstract NewRule setStatus(RuleStatus var1);

        @Deprecated
        public abstract NewRule setDebtSubCharacteristic(@Nullable String var1);

        public abstract DebtRemediationFunctions debtRemediationFunctions();

        public abstract NewRule setDebtRemediationFunction(@Nullable DebtRemediationFunction var1);

        @Deprecated
        public abstract NewRule setEffortToFixDescription(@Nullable String var1);

        public abstract NewRule setGapDescription(@Nullable String var1);

        public abstract NewParam createParam(String var1);

        @CheckForNull
        public abstract NewParam param(String var1);

        public abstract Collection<NewParam> params();

        public abstract NewRule addTags(String ... var1);

        public abstract NewRule setTags(String ... var1);

        public abstract NewRule addOwaspTop10(OwaspTop10 ... var1);

        public abstract NewRule addCwe(int ... var1);

        public abstract NewRule setInternalKey(@Nullable String var1);

        public abstract NewRule addDeprecatedRuleKey(String var1, String var2);
    }

    public static interface DebtRemediationFunctions {
        public DebtRemediationFunction linear(String var1);

        public DebtRemediationFunction linearWithOffset(String var1, String var2);

        public DebtRemediationFunction constantPerIssue(String var1);

        public DebtRemediationFunction create(DebtRemediationFunction.Type var1, @Nullable String var2, @Nullable String var3);
    }

    public static interface Repository
    extends ExtendedRepository {
        public String name();

        public boolean isExternal();
    }

    public static interface ExtendedRepository {
        public String key();

        public String language();

        @CheckForNull
        public Rule rule(String var1);

        public List<Rule> rules();
    }

    public static enum OwaspTop10 {
        A1,
        A2,
        A3,
        A4,
        A5,
        A6,
        A7,
        A8,
        A9,
        A10;

    }

    public static interface NewRepository
    extends NewExtendedRepository {
        public NewRepository setName(String var1);

        public boolean isExternal();
    }

    public static interface NewExtendedRepository {
        public NewRule createRule(String var1);

        @CheckForNull
        public NewRule rule(String var1);

        public Collection<NewRule> rules();

        public String key();

        public void done();
    }

    public static abstract class AbstractContext {
        public abstract NewRepository createRepository(String var1, String var2);

        public abstract NewRepository createExternalRepository(String var1, String var2);

        @Deprecated
        public abstract NewRepository extendRepository(String var1, String var2);

        @CheckForNull
        public abstract Repository repository(String var1);

        public abstract List<Repository> repositories();

        @Deprecated
        public abstract List<ExtendedRepository> extendedRepositories(String var1);

        @Deprecated
        public abstract List<ExtendedRepository> extendedRepositories();

        public abstract void setCurrentPluginKey(@Nullable String var1);
    }

    public static class Context
    extends AbstractContext {
        private final Map<String, Repository> repositoriesByKey = new HashMap<String, Repository>();
        private String currentPluginKey = null;

        @Override
        public NewRepository createRepository(String key, String language) {
            return new DefaultNewRepository(this, key, language, false);
        }

        @Override
        public NewRepository createExternalRepository(String engineId, String language) {
            return new DefaultNewRepository(this, "external_" + engineId, language, true);
        }

        @Override
        @Deprecated
        public NewRepository extendRepository(String key, String language) {
            return this.createRepository(key, language);
        }

        @Override
        @CheckForNull
        public Repository repository(String key) {
            return this.repositoriesByKey.get(key);
        }

        @Override
        public List<Repository> repositories() {
            return Collections.unmodifiableList(new ArrayList<Repository>(this.repositoriesByKey.values()));
        }

        @Override
        @Deprecated
        public List<ExtendedRepository> extendedRepositories(String repositoryKey) {
            return Collections.emptyList();
        }

        @Override
        @Deprecated
        public List<ExtendedRepository> extendedRepositories() {
            return Collections.emptyList();
        }

        public void registerRepository(DefaultNewRepository newRepository) {
            Repository existing = this.repositoriesByKey.get(newRepository.key());
            if (existing != null) {
                String existingLanguage = existing.language();
                Preconditions.checkState(existingLanguage.equals(newRepository.language()), "The rule repository '%s' must not be defined for two different languages: %s and %s", newRepository.key(), existingLanguage, newRepository.language());
            }
            this.repositoriesByKey.put(newRepository.key(), new DefaultRepository(newRepository, existing));
        }

        public String currentPluginKey() {
            return this.currentPluginKey;
        }

        @Override
        public void setCurrentPluginKey(@Nullable String pluginKey) {
            this.currentPluginKey = pluginKey;
        }
    }

    @Deprecated
    public static final class SubCharacteristics {
        public static final String MODULARITY = "MODULARITY";
        public static final String TRANSPORTABILITY = "TRANSPORTABILITY";
        public static final String COMPILER_RELATED_PORTABILITY = "COMPILER_RELATED_PORTABILITY";
        public static final String HARDWARE_RELATED_PORTABILITY = "HARDWARE_RELATED_PORTABILITY";
        public static final String LANGUAGE_RELATED_PORTABILITY = "LANGUAGE_RELATED_PORTABILITY";
        public static final String OS_RELATED_PORTABILITY = "OS_RELATED_PORTABILITY";
        public static final String SOFTWARE_RELATED_PORTABILITY = "SOFTWARE_RELATED_PORTABILITY";
        public static final String TIME_ZONE_RELATED_PORTABILITY = "TIME_ZONE_RELATED_PORTABILITY";
        public static final String READABILITY = "READABILITY";
        public static final String UNDERSTANDABILITY = "UNDERSTANDABILITY";
        public static final String API_ABUSE = "API_ABUSE";
        public static final String ERRORS = "ERRORS";
        public static final String INPUT_VALIDATION_AND_REPRESENTATION = "INPUT_VALIDATION_AND_REPRESENTATION";
        public static final String SECURITY_FEATURES = "SECURITY_FEATURES";
        public static final String CPU_EFFICIENCY = "CPU_EFFICIENCY";
        public static final String MEMORY_EFFICIENCY = "MEMORY_EFFICIENCY";
        public static final String NETWORK_USE = "NETWORK_USE";
        public static final String ARCHITECTURE_CHANGEABILITY = "ARCHITECTURE_CHANGEABILITY";
        public static final String DATA_CHANGEABILITY = "DATA_CHANGEABILITY";
        public static final String LOGIC_CHANGEABILITY = "LOGIC_CHANGEABILITY";
        public static final String ARCHITECTURE_RELIABILITY = "ARCHITECTURE_RELIABILITY";
        public static final String DATA_RELIABILITY = "DATA_RELIABILITY";
        public static final String EXCEPTION_HANDLING = "EXCEPTION_HANDLING";
        public static final String FAULT_TOLERANCE = "FAULT_TOLERANCE";
        public static final String INSTRUCTION_RELIABILITY = "INSTRUCTION_RELIABILITY";
        public static final String LOGIC_RELIABILITY = "LOGIC_RELIABILITY";
        public static final String RESOURCE_RELIABILITY = "RESOURCE_RELIABILITY";
        public static final String SYNCHRONIZATION_RELIABILITY = "SYNCHRONIZATION_RELIABILITY";
        public static final String UNIT_TESTS = "UNIT_TESTS";
        public static final String INTEGRATION_TESTABILITY = "INTEGRATION_TESTABILITY";
        public static final String UNIT_TESTABILITY = "UNIT_TESTABILITY";
        public static final String USABILITY_ACCESSIBILITY = "USABILITY_ACCESSIBILITY";
        public static final String USABILITY_COMPLIANCE = "USABILITY_COMPLIANCE";
        public static final String USABILITY_EASE_OF_USE = "USABILITY_EASE_OF_USE";
        public static final String REUSABILITY_COMPLIANCE = "REUSABILITY_COMPLIANCE";
        public static final String PORTABILITY_COMPLIANCE = "PORTABILITY_COMPLIANCE";
        public static final String MAINTAINABILITY_COMPLIANCE = "MAINTAINABILITY_COMPLIANCE";
        public static final String SECURITY_COMPLIANCE = "SECURITY_COMPLIANCE";
        public static final String EFFICIENCY_COMPLIANCE = "EFFICIENCY_COMPLIANCE";
        public static final String CHANGEABILITY_COMPLIANCE = "CHANGEABILITY_COMPLIANCE";
        public static final String RELIABILITY_COMPLIANCE = "RELIABILITY_COMPLIANCE";
        public static final String TESTABILITY_COMPLIANCE = "TESTABILITY_COMPLIANCE";

        private SubCharacteristics() {
        }
    }
}

