/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.debt.internal;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.apachecommons.lang.builder.EqualsBuilder;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.utils.Duration;
import org.sonar.api.utils.Preconditions;

public class DefaultDebtRemediationFunction
implements DebtRemediationFunction {
    private static final int HOURS_IN_DAY = 24;
    private final DebtRemediationFunction.Type type;
    private final String gapMultiplier;
    private final String baseEffort;

    public DefaultDebtRemediationFunction(@Nullable DebtRemediationFunction.Type type, @Nullable String gapMultiplier, @Nullable String baseEffort) {
        this.type = type;
        this.gapMultiplier = DefaultDebtRemediationFunction.sanitizeValue("gap multiplier", gapMultiplier);
        this.baseEffort = DefaultDebtRemediationFunction.sanitizeValue("base effort", baseEffort);
        this.validate();
    }

    @CheckForNull
    private static String sanitizeValue(String label, @Nullable String s) {
        if (StringUtils.isNotBlank(s)) {
            try {
                Duration duration = Duration.decode(s, 24);
                return duration.encode(24);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid %s: %s (%s)", label, s, e.getMessage()), e);
            }
        }
        return null;
    }

    @Override
    public DebtRemediationFunction.Type type() {
        return this.type;
    }

    @Override
    @CheckForNull
    public String gapMultiplier() {
        return this.gapMultiplier;
    }

    @Override
    public String baseEffort() {
        return this.baseEffort;
    }

    private void validate() {
        Preconditions.checkArgument(this.type != null, "Remediation function type cannot be null");
        switch (this.type) {
            case LINEAR: {
                Preconditions.checkArgument(this.gapMultiplier != null && this.baseEffort == null, "Linear functions must only have a non empty gap multiplier");
                break;
            }
            case LINEAR_OFFSET: {
                Preconditions.checkArgument(this.gapMultiplier != null && this.baseEffort != null, "Linear with offset functions must have both non null gap multiplier and base effort");
                break;
            }
            case CONSTANT_ISSUE: {
                Preconditions.checkArgument(this.gapMultiplier == null && this.baseEffort != null, "Constant/issue functions must only have a non empty base effort");
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown type on %s", this));
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultDebtRemediationFunction)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        DefaultDebtRemediationFunction other = (DefaultDebtRemediationFunction)o;
        return new EqualsBuilder().append(this.gapMultiplier, other.gapMultiplier()).append(this.baseEffort, other.baseEffort()).append((Object)this.type, (Object)other.type()).isEquals();
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.gapMultiplier != null ? this.gapMultiplier.hashCode() : 0);
        result = 31 * result + (this.baseEffort != null ? this.baseEffort.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DebtRemediationFunction{type=" + (Object)((Object)this.type) + ", gap multiplier=" + this.gapMultiplier + ", base effort=" + this.baseEffort + "}";
    }
}

