/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.process.ConfigurationUtils;
import org.sonar.process.Lifecycle;
import org.sonar.process.Monitored;
import org.sonar.process.Props;
import org.sonar.process.StopWatcher;
import org.sonar.process.Stoppable;
import org.sonar.process.StopperThread;
import org.sonar.process.SystemExit;
import org.sonar.process.sharedmemoryfile.DefaultProcessCommands;
import org.sonar.process.sharedmemoryfile.ProcessCommands;

public class ProcessEntryPoint
implements Stoppable {
    public static final String PROPERTY_PROCESS_KEY = "process.key";
    public static final String PROPERTY_PROCESS_INDEX = "process.index";
    public static final String PROPERTY_TERMINATION_TIMEOUT_MS = "process.terminationTimeout";
    public static final String PROPERTY_SHARED_PATH = "process.sharedDir";
    private final Props props;
    private final String processKey;
    private final int processNumber;
    private final File sharedDir;
    private final Lifecycle lifecycle = new Lifecycle();
    private final ProcessCommands commands;
    private final SystemExit exit;
    private volatile Monitored monitored;
    private volatile StopperThread stopperThread;
    private final StopWatcher stopWatcher;
    private Thread shutdownHook = new Thread(new Runnable(){

        @Override
        public void run() {
            ProcessEntryPoint.this.exit.setInShutdownHook();
            ProcessEntryPoint.this.stop();
        }
    });

    ProcessEntryPoint(Props props, SystemExit exit, ProcessCommands commands) {
        this(props, ProcessEntryPoint.getProcessNumber(props), ProcessEntryPoint.getSharedDir(props), exit, commands);
    }

    private ProcessEntryPoint(Props props, int processNumber, File sharedDir, SystemExit exit, ProcessCommands commands) {
        this.props = props;
        this.processKey = props.nonNullValue(PROPERTY_PROCESS_KEY);
        this.processNumber = processNumber;
        this.sharedDir = sharedDir;
        this.exit = exit;
        this.commands = commands;
        this.stopWatcher = new StopWatcher(commands, this);
    }

    public ProcessCommands getCommands() {
        return this.commands;
    }

    public Props getProps() {
        return this.props;
    }

    public String getKey() {
        return this.processKey;
    }

    public int getProcessNumber() {
        return this.processNumber;
    }

    public File getSharedDir() {
        return this.sharedDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(Monitored mp) {
        if (!this.lifecycle.tryToMoveTo(Lifecycle.State.STARTING)) {
            throw new IllegalStateException("Already started");
        }
        this.monitored = mp;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        try {
            this.launch(logger);
        }
        catch (Exception e) {
            logger.warn("Fail to start {}", (Object)this.getKey(), (Object)e);
        }
        finally {
            this.stop();
        }
    }

    private void launch(Logger logger) throws InterruptedException {
        logger.info("Starting {}", (Object)this.getKey());
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.stopWatcher.start();
        this.monitored.start();
        Monitored.Status status = this.waitForNotDownStatus();
        if (status == Monitored.Status.UP || status == Monitored.Status.OPERATIONAL) {
            this.commands.setUp();
            if (this.lifecycle.tryToMoveTo(Lifecycle.State.STARTED)) {
                Monitored.Status newStatus = this.waitForOperational(status);
                if (newStatus == Monitored.Status.OPERATIONAL && this.lifecycle.tryToMoveTo(Lifecycle.State.OPERATIONAL)) {
                    this.commands.setOperational();
                }
                this.monitored.awaitStop();
            }
        } else {
            this.stop();
        }
    }

    private Monitored.Status waitForNotDownStatus() throws InterruptedException {
        Monitored.Status status = Monitored.Status.DOWN;
        while (status == Monitored.Status.DOWN) {
            status = this.monitored.getStatus();
            Thread.sleep(20L);
        }
        return status;
    }

    private Monitored.Status waitForOperational(Monitored.Status currentStatus) throws InterruptedException {
        Monitored.Status status = currentStatus;
        while (status != Monitored.Status.OPERATIONAL && status != Monitored.Status.FAILED) {
            status = this.monitored.getStatus();
            Thread.sleep(20L);
        }
        return status;
    }

    boolean isStarted() {
        return this.lifecycle.getState() == Lifecycle.State.STARTED;
    }

    void stop() {
        this.stopAsync();
        try {
            this.stopperThread.join();
            this.lifecycle.tryToMoveTo(Lifecycle.State.STOPPED);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.exit.exit(0);
    }

    @Override
    public void stopAsync() {
        if (this.lifecycle.tryToMoveTo(Lifecycle.State.STOPPING)) {
            this.stopperThread = new StopperThread(this.monitored, this.commands, Long.parseLong(this.props.nonNullValue(PROPERTY_TERMINATION_TIMEOUT_MS)));
            this.stopperThread.start();
            this.stopWatcher.stopWatching();
        }
    }

    Lifecycle.State getState() {
        return this.lifecycle.getState();
    }

    Thread getShutdownHook() {
        return this.shutdownHook;
    }

    public static ProcessEntryPoint createForArguments(String[] args) {
        Props props = ConfigurationUtils.loadPropsFromCommandLineArgs(args);
        File sharedDir = ProcessEntryPoint.getSharedDir(props);
        int processNumber = ProcessEntryPoint.getProcessNumber(props);
        DefaultProcessCommands commands = DefaultProcessCommands.main(sharedDir, processNumber);
        return new ProcessEntryPoint(props, processNumber, sharedDir, new SystemExit(), commands);
    }

    private static int getProcessNumber(Props props) {
        return Integer.parseInt(props.nonNullValue(PROPERTY_PROCESS_INDEX));
    }

    private static File getSharedDir(Props props) {
        return props.nonNullValueAsFile(PROPERTY_SHARED_PATH);
    }
}

