/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;
import org.sonar.process.Monitored;
import org.sonar.process.sharedmemoryfile.ProcessCommands;

class StopperThread
extends Thread {
    private final Monitored monitored;
    private final long terminationTimeoutMs;
    private final ProcessCommands commands;

    StopperThread(Monitored monitored, ProcessCommands commands, long terminationTimeoutMs) {
        super("Stopper");
        this.monitored = monitored;
        this.terminationTimeoutMs = terminationTimeoutMs;
        this.commands = commands;
    }

    @Override
    public void run() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<?> future = executor.submit(this.monitored::stop);
            future.get(this.terminationTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Can not stop in {}ms", (Object)this.terminationTimeoutMs, (Object)e);
        }
        executor.shutdownNow();
        this.commands.endWatch();
    }
}

