/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.cluster.hz;

import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.Hazelcast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.process.ProcessId;
import org.sonar.process.ProcessProperties;
import org.sonar.process.cluster.hz.HazelcastMember;
import org.sonar.process.cluster.hz.HazelcastMemberImpl;

public class HazelcastMemberBuilder {
    private String nodeName;
    private int port;
    private ProcessId processId;
    private String networkInterface;
    private List<String> members = new ArrayList<String>();

    public HazelcastMemberBuilder setNodeName(String s) {
        this.nodeName = s;
        return this;
    }

    public HazelcastMemberBuilder setProcessId(ProcessId p) {
        if (p == ProcessId.ELASTICSEARCH) {
            throw new IllegalArgumentException("Hazelcast must not be enabled on Elasticsearch node");
        }
        this.processId = p;
        return this;
    }

    public HazelcastMemberBuilder setPort(int i) {
        this.port = i;
        return this;
    }

    public HazelcastMemberBuilder setNetworkInterface(String s) {
        this.networkInterface = s;
        return this;
    }

    @CheckForNull
    List<String> getMembers() {
        return this.members;
    }

    public HazelcastMemberBuilder setMembers(Collection<String> c) {
        this.members = c.stream().map(host -> host.contains(":") ? host : String.format("%s:%s", host, ProcessProperties.Property.CLUSTER_NODE_HZ_PORT.getDefaultValue())).collect(Collectors.toList());
        return this;
    }

    public HazelcastMember build() {
        Config config = new Config();
        config.getGroupConfig().setName("SonarQube");
        NetworkConfig netConfig = config.getNetworkConfig();
        netConfig.setPort(this.port).setPortAutoIncrement(false).setReuseAddress(true);
        netConfig.getInterfaces().setEnabled(true).setInterfaces(Collections.singletonList(Objects.requireNonNull(this.networkInterface, "Network interface is missing")));
        JoinConfig joinConfig = netConfig.getJoin();
        joinConfig.getAwsConfig().setEnabled(false);
        joinConfig.getMulticastConfig().setEnabled(false);
        joinConfig.getTcpIpConfig().setEnabled(true);
        joinConfig.getTcpIpConfig().setMembers(Objects.requireNonNull(this.members, "Members are missing"));
        config.getPartitionGroupConfig().setEnabled(false);
        config.setProperty("hazelcast.tcp.join.port.try.count", "10").setProperty("hazelcast.socket.bind.any", "false").setProperty("hazelcast.phone.home.enabled", "false").setProperty("hazelcast.logging.type", "slf4j");
        MemberAttributeConfig attributes = config.getMemberAttributeConfig();
        attributes.setStringAttribute(HazelcastMember.Attribute.NODE_NAME.getKey(), Objects.requireNonNull(this.nodeName, "Node name is missing"));
        attributes.setStringAttribute(HazelcastMember.Attribute.PROCESS_KEY.getKey(), Objects.requireNonNull(this.processId, "Process key is missing").getKey());
        return new HazelcastMemberImpl(Hazelcast.newHazelcastInstance((Config)config));
    }
}

