/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.logging;

import ch.qos.logback.classic.Level;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.sonar.process.MessageException;
import org.sonar.process.Props;
import org.sonar.process.logging.AbstractLogHelper;
import org.sonar.process.logging.LogLevelConfig;
import org.sonar.process.logging.RootLoggerConfig;

public class Log4JPropertiesBuilder
extends AbstractLogHelper {
    private static final String ROOT_LOGGER_NAME = "rootLogger";
    private static final int UNLIMITED_MAX_FILES = 100000;
    private final Properties log4j2Properties = new Properties();
    private final Props props;

    public Log4JPropertiesBuilder(Props props) {
        super("%logger{1.}");
        this.props = Objects.requireNonNull(props, "Props can't be null");
        this.internalLogLevel(Level.ERROR);
    }

    @Override
    public String getRootLoggerName() {
        return ROOT_LOGGER_NAME;
    }

    public Properties get() {
        Properties res = new Properties();
        res.putAll((Map<?, ?>)this.log4j2Properties);
        return res;
    }

    public void internalLogLevel(Level level) {
        this.putProperty("status", level.toString());
    }

    private void putProperty(String key, String value) {
        this.log4j2Properties.put(key, value);
    }

    public void configureGlobalFileLog(RootLoggerConfig config, File logDir, String logPattern) {
        String appenderRef = this.writeFileAppender(config, logDir, logPattern);
        this.putProperty("rootLogger.appenderRef." + appenderRef + ".ref", appenderRef);
    }

    private String writeFileAppender(RootLoggerConfig config, File logDir, String logPattern) {
        String appenderName = "file_" + config.getProcessId().getLogFilenamePrefix();
        RollingPolicy rollingPolicy = this.createRollingPolicy(logDir, config.getProcessId().getLogFilenamePrefix());
        Appender appender = new Appender(appenderName, rollingPolicy, logPattern);
        appender.writeAppenderProperties();
        return appender.getAppenderRef();
    }

    private RollingPolicy createRollingPolicy(File logDir, String filenamePrefix) {
        String rollingPolicy = this.props.value("sonar.log.rollingPolicy", "time:yyyy-MM-dd");
        int maxFiles = this.props.valueAsInt("sonar.log.maxFiles", 7);
        if (maxFiles <= 0) {
            maxFiles = 100000;
        }
        if (rollingPolicy.startsWith("time:")) {
            return new TimeRollingPolicy(filenamePrefix, logDir, maxFiles, StringUtils.substringAfter((String)rollingPolicy, (String)"time:"));
        }
        if (rollingPolicy.startsWith("size:")) {
            return new SizeRollingPolicy(filenamePrefix, logDir, maxFiles, StringUtils.substringAfter((String)rollingPolicy, (String)"size:"));
        }
        if ("none".equals(rollingPolicy)) {
            return new NoRollingPolicy(filenamePrefix, logDir);
        }
        throw new MessageException(String.format("Unsupported value for property %s: %s", "sonar.log.rollingPolicy", rollingPolicy));
    }

    public void apply(LogLevelConfig logLevelConfig) {
        if (!ROOT_LOGGER_NAME.equals(logLevelConfig.getRootLoggerName())) {
            throw new IllegalArgumentException("Value of LogLevelConfig#rootLoggerName must be \"rootLogger\"");
        }
        Level propertyValueAsLevel = Log4JPropertiesBuilder.getPropertyValueAsLevel(this.props, "sonar.log.level");
        boolean traceGloballyEnabled = propertyValueAsLevel == Level.TRACE;
        List loggerNames = Stream.of(logLevelConfig.getConfiguredByProperties().keySet().stream(), logLevelConfig.getConfiguredByHardcodedLevel().keySet().stream(), logLevelConfig.getOffUnlessTrace().stream().filter(k -> !traceGloballyEnabled)).flatMap(s -> s).filter(loggerName -> !ROOT_LOGGER_NAME.equals(loggerName)).distinct().sorted().collect(Collectors.toList());
        if (!loggerNames.isEmpty()) {
            this.putProperty("loggers", loggerNames.stream().collect(Collectors.joining(",")));
        }
        logLevelConfig.getConfiguredByProperties().forEach((loggerName, value) -> this.applyLevelByProperty(this.props, (String)loggerName, (List<String>)value));
        logLevelConfig.getConfiguredByHardcodedLevel().forEach(this::applyHardcodedLevel);
        logLevelConfig.getOffUnlessTrace().stream().filter(k -> !traceGloballyEnabled).forEach(logger -> this.applyHardcodedLevel((String)logger, Level.OFF));
    }

    private void applyLevelByProperty(Props props, String loggerKey, List<String> properties) {
        this.putLevel(loggerKey, Log4JPropertiesBuilder.resolveLevel(props, (String[])properties.stream().toArray(String[]::new)));
    }

    private void applyHardcodedLevel(String loggerName, Level newLevel) {
        this.putLevel(loggerName, newLevel);
    }

    private void putLevel(String loggerName, Level level) {
        if (loggerName.equals(ROOT_LOGGER_NAME)) {
            this.putProperty(loggerName + ".level", level.toString());
        } else {
            this.putProperty("logger." + loggerName + ".name", loggerName);
            this.putProperty("logger." + loggerName + ".level", level.toString());
        }
    }

    private class SizeRollingPolicy
    extends RollingPolicy {
        private final String size;
        private final int maxFiles;

        private SizeRollingPolicy(String filenamePrefix, File logsDir, int maxFiles, String size) {
            super(filenamePrefix, logsDir);
            this.size = size;
            this.maxFiles = maxFiles;
        }

        @Override
        public void writePolicy(String propertyPrefix) {
            this.writeTypeProperty(propertyPrefix, "RollingFile");
            this.writeFileNameProperty(propertyPrefix);
            this.writeFilePatternProperty(propertyPrefix, "%i");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "policies.type", "Policies");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "policies.size.type", "SizeBasedTriggeringPolicy");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "policies.size.size", this.size);
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "strategy.type", "DefaultRolloverStrategy");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "strategy.max", String.valueOf(this.maxFiles));
        }
    }

    private class TimeRollingPolicy
    extends RollingPolicy {
        private final String datePattern;
        private final int maxFiles;

        private TimeRollingPolicy(String filenamePrefix, File logsDir, int maxFiles, String datePattern) {
            super(filenamePrefix, logsDir);
            this.datePattern = datePattern;
            this.maxFiles = maxFiles;
        }

        @Override
        public void writePolicy(String propertyPrefix) {
            this.writeTypeProperty(propertyPrefix, "RollingFile");
            this.writeFileNameProperty(propertyPrefix);
            this.writeFilePatternProperty(propertyPrefix, "%d{" + this.datePattern + "}");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "policies.type", "Policies");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "policies.time.type", "TimeBasedTriggeringPolicy");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "policies.time.interval", "1");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "policies.time.modulate", "true");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "strategy.type", "DefaultRolloverStrategy");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "strategy.fileIndex", "nomax");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "strategy.action.type", "Delete");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "strategy.action.basepath", this.logsDir.getAbsolutePath());
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "strategy.action.maxDepth", String.valueOf(1));
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "strategy.action.condition.type", "IfFileName");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "strategy.action.condition.glob", this.filenamePrefix + "*");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "strategy.action.condition.nested_condition.type", "IfAccumulatedFileCount");
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "strategy.action.condition.nested_condition.exceeds", String.valueOf(this.maxFiles));
        }
    }

    private class NoRollingPolicy
    extends RollingPolicy {
        private NoRollingPolicy(String filenamePrefix, File logsDir) {
            super(filenamePrefix, logsDir);
        }

        @Override
        public void writePolicy(String propertyPrefix) {
            this.writeTypeProperty(propertyPrefix, "File");
            this.writeFileNameProperty(propertyPrefix);
        }
    }

    private abstract class RollingPolicy {
        final String filenamePrefix;
        final File logsDir;

        RollingPolicy(String filenamePrefix, File logsDir) {
            this.filenamePrefix = filenamePrefix;
            this.logsDir = logsDir;
        }

        abstract void writePolicy(String var1);

        void writeTypeProperty(String propertyPrefix, String type) {
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "type", type);
        }

        void writeFileNameProperty(String propertyPrefix) {
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "fileName", new File(this.logsDir, this.filenamePrefix + ".log").getAbsolutePath());
        }

        void writeFilePatternProperty(String propertyPrefix, String pattern) {
            Log4JPropertiesBuilder.this.putProperty(propertyPrefix + "filePattern", new File(this.logsDir, this.filenamePrefix + "." + pattern + ".log").getAbsolutePath());
        }
    }

    private class Appender {
        private final String prefix;
        private final String appenderName;
        private final RollingPolicy rollingPolicy;
        private final String logPattern;

        private Appender(String appenderName, RollingPolicy rollingPolicy, String logPattern) {
            this.prefix = "appender." + appenderName + ".";
            this.appenderName = appenderName;
            this.rollingPolicy = rollingPolicy;
            this.logPattern = logPattern;
        }

        void writeAppenderProperties() {
            this.put("name", this.appenderName);
            this.put("layout.type", "PatternLayout");
            this.put("layout.pattern", this.logPattern);
            this.rollingPolicy.writePolicy(this.prefix);
        }

        void put(String key, String value) {
            Log4JPropertiesBuilder.this.putProperty(this.prefix + key, value);
        }

        String getAppenderRef() {
            return this.appenderName;
        }
    }
}

