/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.LogManager;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.sonar.process.MessageException;
import org.sonar.process.ProcessProperties;
import org.sonar.process.Props;
import org.sonar.process.logging.AbstractLogHelper;
import org.sonar.process.logging.LogLevelConfig;
import org.sonar.process.logging.RootLoggerConfig;

public class LogbackHelper
extends AbstractLogHelper {
    private static final String ALL_LOGS_TO_CONSOLE_PROPERTY = "sonar.log.console";
    private static final String LOGBACK_LOGGER_NAME_PATTERN = "%logger{20}";

    public LogbackHelper() {
        super(LOGBACK_LOGGER_NAME_PATTERN);
    }

    public static Collection<Level> allowedLogLevels() {
        return Arrays.asList(ALLOWED_ROOT_LOG_LEVELS);
    }

    @Override
    public String getRootLoggerName() {
        return "ROOT";
    }

    public LoggerContext getRootContext() {
        Logger logger;
        while (!((logger = LoggerFactory.getLogger((String)"ROOT")) instanceof ch.qos.logback.classic.Logger)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return ((ch.qos.logback.classic.Logger)logger).getLoggerContext();
    }

    public LoggerContextListener enableJulChangePropagation(LoggerContext loggerContext) {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        LevelChangePropagator propagator = new LevelChangePropagator();
        propagator.setContext((Context)loggerContext);
        propagator.setResetJUL(true);
        propagator.start();
        loggerContext.addListener((LoggerContextListener)propagator);
        return propagator;
    }

    public LoggerContext apply(LogLevelConfig logLevelConfig, Props props) {
        if (!"ROOT".equals(logLevelConfig.getRootLoggerName())) {
            throw new IllegalArgumentException("Value of LogLevelConfig#rootLoggerName must be \"ROOT\"");
        }
        LoggerContext rootContext = this.getRootContext();
        logLevelConfig.getConfiguredByProperties().forEach((key, value) -> this.applyLevelByProperty(props, rootContext.getLogger(key), (List<String>)value));
        logLevelConfig.getConfiguredByHardcodedLevel().forEach((key, value) -> LogbackHelper.applyHardcodedLevel(rootContext, key, value));
        Level propertyValueAsLevel = LogbackHelper.getPropertyValueAsLevel(props, "sonar.log.level");
        boolean traceGloballyEnabled = propertyValueAsLevel == Level.TRACE;
        logLevelConfig.getOffUnlessTrace().forEach(logger -> LogbackHelper.applyHardUnlessTrace(rootContext, logger, traceGloballyEnabled));
        return rootContext;
    }

    private void applyLevelByProperty(Props props, ch.qos.logback.classic.Logger logger, List<String> properties) {
        logger.setLevel(LogbackHelper.resolveLevel(props, (String[])properties.stream().toArray(String[]::new)));
    }

    private static void applyHardcodedLevel(LoggerContext rootContext, String loggerName, Level newLevel) {
        rootContext.getLogger(loggerName).setLevel(newLevel);
    }

    private static void applyHardUnlessTrace(LoggerContext rootContext, String logger, boolean traceGloballyEnabled) {
        if (!traceGloballyEnabled) {
            rootContext.getLogger(logger).setLevel(Level.OFF);
        }
    }

    public void changeRoot(LogLevelConfig logLevelConfig, Level newLevel) {
        LogbackHelper.ensureSupportedLevel(newLevel);
        LoggerContext rootContext = this.getRootContext();
        rootContext.getLogger("ROOT").setLevel(newLevel);
        logLevelConfig.getConfiguredByProperties().forEach((key, value) -> rootContext.getLogger(key).setLevel(newLevel));
    }

    private static void ensureSupportedLevel(Level newLevel) {
        if (!LogbackHelper.isAllowed(newLevel)) {
            throw new IllegalArgumentException(String.format("%s log level is not supported (allowed levels are %s)", newLevel, Arrays.toString(ALLOWED_ROOT_LOG_LEVELS)));
        }
    }

    public ConsoleAppender<ILoggingEvent> newConsoleAppender(Context loggerContext, String name, String logPattern) {
        PatternLayoutEncoder consoleEncoder = new PatternLayoutEncoder();
        consoleEncoder.setContext(loggerContext);
        consoleEncoder.setPattern(logPattern);
        consoleEncoder.start();
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setContext(loggerContext);
        consoleAppender.setEncoder((Encoder)consoleEncoder);
        consoleAppender.setName(name);
        consoleAppender.setTarget("System.out");
        consoleAppender.start();
        return consoleAppender;
    }

    public FileAppender<ILoggingEvent> configureGlobalFileLog(Props props, RootLoggerConfig config, String logPattern) {
        LoggerContext ctx = this.getRootContext();
        ch.qos.logback.classic.Logger rootLogger = ctx.getLogger("ROOT");
        FileAppender<ILoggingEvent> fileAppender = this.newFileAppender(ctx, props, config, logPattern);
        rootLogger.addAppender(fileAppender);
        return fileAppender;
    }

    public FileAppender<ILoggingEvent> newFileAppender(LoggerContext ctx, Props props, RootLoggerConfig config, String logPattern) {
        RollingPolicy rollingPolicy = this.createRollingPolicy((Context)ctx, props, config.getProcessId().getLogFilenamePrefix());
        FileAppender<ILoggingEvent> fileAppender = rollingPolicy.createAppender("file_" + config.getProcessId().getLogFilenamePrefix());
        fileAppender.setContext((Context)ctx);
        PatternLayoutEncoder fileEncoder = new PatternLayoutEncoder();
        fileEncoder.setContext((Context)ctx);
        fileEncoder.setPattern(logPattern);
        fileEncoder.start();
        fileAppender.setEncoder((Encoder)fileEncoder);
        fileAppender.start();
        return fileAppender;
    }

    public void configureForSubprocessGobbler(Props props, String logPattern) {
        if (this.isAllLogsToConsoleEnabled(props)) {
            LoggerContext ctx = this.getRootContext();
            ctx.getLogger("ROOT").addAppender(this.newConsoleAppender((Context)ctx, "root_console", logPattern));
        }
    }

    public boolean isAllLogsToConsoleEnabled(Props props) {
        return props.valueAsBoolean(ALL_LOGS_TO_CONSOLE_PROPERTY, false);
    }

    public Level getLoggerLevel(String loggerName) {
        return this.getRootContext().getLogger(loggerName).getLevel();
    }

    public void resetFromXml(String xmlResourcePath) throws JoranException {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)context);
        context.reset();
        configurator.doConfigure(LogbackHelper.class.getResource(xmlResourcePath));
    }

    public RollingPolicy createRollingPolicy(Context ctx, Props props, String filenamePrefix) {
        String rollingPolicy = props.value("sonar.log.rollingPolicy", "time:yyyy-MM-dd");
        int maxFiles = props.valueAsInt("sonar.log.maxFiles", 7);
        File logsDir = props.nonNullValueAsFile(ProcessProperties.Property.PATH_LOGS.getKey());
        if (rollingPolicy.startsWith("time:")) {
            return new TimeRollingPolicy(ctx, filenamePrefix, logsDir, maxFiles, StringUtils.substringAfter((String)rollingPolicy, (String)"time:"));
        }
        if (rollingPolicy.startsWith("size:")) {
            return new SizeRollingPolicy(ctx, filenamePrefix, logsDir, maxFiles, StringUtils.substringAfter((String)rollingPolicy, (String)"size:"));
        }
        if ("none".equals(rollingPolicy)) {
            return new NoRollingPolicy(ctx, filenamePrefix, logsDir, maxFiles);
        }
        throw new MessageException(String.format("Unsupported value for property %s: %s", "sonar.log.rollingPolicy", rollingPolicy));
    }

    private static class SizeRollingPolicy
    extends RollingPolicy {
        private final String size;

        private SizeRollingPolicy(Context context, String filenamePrefix, File logsDir, int maxFiles, String parameter) {
            super(context, filenamePrefix, logsDir, maxFiles);
            this.size = parameter;
        }

        @Override
        public FileAppender<ILoggingEvent> createAppender(String appenderName) {
            RollingFileAppender appender = new RollingFileAppender();
            appender.setContext(this.context);
            appender.setName(appenderName);
            String filePath = new File(this.logsDir, this.filenamePrefix + ".log").getAbsolutePath();
            appender.setFile(filePath);
            SizeBasedTriggeringPolicy trigger = new SizeBasedTriggeringPolicy();
            trigger.setMaxFileSize(FileSize.valueOf((String)this.size));
            trigger.setContext(this.context);
            trigger.start();
            appender.setTriggeringPolicy((TriggeringPolicy)trigger);
            FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
            rollingPolicy.setContext(this.context);
            rollingPolicy.setFileNamePattern(StringUtils.replace((String)filePath, (String)(this.filenamePrefix + ".log"), (String)(this.filenamePrefix + ".%i.log")));
            rollingPolicy.setMinIndex(1);
            rollingPolicy.setMaxIndex(this.maxFiles);
            rollingPolicy.setParent((FileAppender)appender);
            rollingPolicy.start();
            appender.setRollingPolicy((ch.qos.logback.core.rolling.RollingPolicy)rollingPolicy);
            return appender;
        }
    }

    private static class TimeRollingPolicy
    extends RollingPolicy {
        private final String datePattern;

        private TimeRollingPolicy(Context context, String filenamePrefix, File logsDir, int maxFiles, String datePattern) {
            super(context, filenamePrefix, logsDir, maxFiles);
            this.datePattern = datePattern;
        }

        @Override
        public FileAppender<ILoggingEvent> createAppender(String appenderName) {
            RollingFileAppender appender = new RollingFileAppender();
            appender.setContext(this.context);
            appender.setName(appenderName);
            String filePath = new File(this.logsDir, this.filenamePrefix + ".log").getAbsolutePath();
            appender.setFile(filePath);
            TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
            rollingPolicy.setContext(this.context);
            rollingPolicy.setFileNamePattern(StringUtils.replace((String)filePath, (String)(this.filenamePrefix + ".log"), (String)(this.filenamePrefix + ".%d{" + this.datePattern + "}.log")));
            rollingPolicy.setMaxHistory(this.maxFiles);
            rollingPolicy.setParent((FileAppender)appender);
            rollingPolicy.start();
            appender.setRollingPolicy((ch.qos.logback.core.rolling.RollingPolicy)rollingPolicy);
            return appender;
        }
    }

    private static class NoRollingPolicy
    extends RollingPolicy {
        private NoRollingPolicy(Context context, String filenamePrefix, File logsDir, int maxFiles) {
            super(context, filenamePrefix, logsDir, maxFiles);
        }

        @Override
        public FileAppender<ILoggingEvent> createAppender(String appenderName) {
            FileAppender appender = new FileAppender();
            appender.setContext(this.context);
            appender.setFile(new File(this.logsDir, this.filenamePrefix + ".log").getAbsolutePath());
            appender.setName(appenderName);
            return appender;
        }
    }

    public static abstract class RollingPolicy {
        protected final Context context;
        final String filenamePrefix;
        final File logsDir;
        final int maxFiles;

        RollingPolicy(Context context, String filenamePrefix, File logsDir, int maxFiles) {
            this.context = context;
            this.filenamePrefix = filenamePrefix;
            this.logsDir = logsDir;
            this.maxFiles = maxFiles;
        }

        public abstract FileAppender<ILoggingEvent> createAppender(String var1);
    }
}

