/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.systeminfo;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;

public class JvmPropertiesSection
implements SystemInfoSection {
    private final String name;

    public JvmPropertiesSection(String name) {
        this.name = name;
    }

    @Override
    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder protobuf = ProtobufSystemInfo.Section.newBuilder();
        protobuf.setName(this.name);
        TreeMap<Object, Object> sortedProperties = new TreeMap<Object, Object>(System.getProperties());
        for (Map.Entry systemProp : sortedProperties.entrySet()) {
            if (systemProp.getValue() == null) continue;
            SystemInfoUtils.setAttribute(protobuf, Objects.toString(systemProp.getKey()), Objects.toString(systemProp.getValue()));
        }
        return protobuf.build();
    }
}

