/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.systeminfo;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Locale;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;

public class JvmStateSection
implements SystemInfoSection {
    private static final long MEGABYTE = 0x100000L;
    private final String name;

    public JvmStateSection(String name) {
        this.name = name;
    }

    @Override
    public ProtobufSystemInfo.Section toProtobuf() {
        return this.toProtobuf(ManagementFactory.getMemoryMXBean());
    }

    ProtobufSystemInfo.Section toProtobuf(MemoryMXBean memoryBean) {
        ProtobufSystemInfo.Section.Builder protobuf = ProtobufSystemInfo.Section.newBuilder();
        protobuf.setName(this.name);
        JvmStateSection.addAttributeInMb(protobuf, "Max Memory (MB)", Runtime.getRuntime().maxMemory());
        JvmStateSection.addAttributeInMb(protobuf, "Free Memory (MB)", Runtime.getRuntime().freeMemory());
        MemoryUsage heap = memoryBean.getHeapMemoryUsage();
        JvmStateSection.addAttributeInMb(protobuf, "Heap Committed (MB)", heap.getCommitted());
        JvmStateSection.addAttributeInMb(protobuf, "Heap Init (MB)", heap.getInit());
        JvmStateSection.addAttributeInMb(protobuf, "Heap Max (MB)", heap.getMax());
        JvmStateSection.addAttributeInMb(protobuf, "Heap Used (MB)", heap.getUsed());
        MemoryUsage nonHeap = memoryBean.getNonHeapMemoryUsage();
        JvmStateSection.addAttributeInMb(protobuf, "Non Heap Committed (MB)", nonHeap.getCommitted());
        JvmStateSection.addAttributeInMb(protobuf, "Non Heap Init (MB)", nonHeap.getInit());
        JvmStateSection.addAttributeInMb(protobuf, "Non Heap Max (MB)", nonHeap.getMax());
        JvmStateSection.addAttributeInMb(protobuf, "Non Heap Used (MB)", nonHeap.getUsed());
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        SystemInfoUtils.setAttribute(protobuf, "System Load Average", String.format(Locale.ENGLISH, "%.1f%% (last minute)", os.getSystemLoadAverage() * 100.0));
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        SystemInfoUtils.setAttribute(protobuf, "Threads", thread.getThreadCount());
        return protobuf.build();
    }

    private static void addAttributeInMb(ProtobufSystemInfo.Section.Builder protobuf, String key, long valueInBytes) {
        if (valueInBytes >= 0L) {
            SystemInfoUtils.setAttribute(protobuf, key, valueInBytes / 0x100000L);
        }
    }
}

