/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.systeminfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;

public class SystemInfoUtils {
    private SystemInfoUtils() {
    }

    public static void setAttribute(ProtobufSystemInfo.Section.Builder section, String key, @Nullable String value) {
        if (value != null) {
            section.addAttributesBuilder().setKey(key).setStringValue(value).build();
        }
    }

    public static void setAttribute(ProtobufSystemInfo.Section.Builder section, String key, @Nullable Collection<String> values) {
        if (values != null) {
            section.addAttributesBuilder().setKey(key).addAllStringValues(values).build();
        }
    }

    public static void setAttribute(ProtobufSystemInfo.Section.Builder section, String key, @Nullable Boolean value) {
        if (value != null) {
            section.addAttributesBuilder().setKey(key).setBooleanValue(value).build();
        }
    }

    public static void setAttribute(ProtobufSystemInfo.Section.Builder section, String key, long value) {
        section.addAttributesBuilder().setKey(key).setLongValue(value).build();
    }

    @CheckForNull
    public static ProtobufSystemInfo.Attribute attribute(ProtobufSystemInfo.Section section, String key) {
        for (ProtobufSystemInfo.Attribute attribute : section.getAttributesList()) {
            if (!attribute.getKey().equals(key)) continue;
            return attribute;
        }
        return null;
    }

    public static List<ProtobufSystemInfo.Section> order(Collection<ProtobufSystemInfo.Section> sections, String ... orderedNames) {
        TreeMap alphabeticalOrderedMap = new TreeMap();
        sections.forEach(section -> alphabeticalOrderedMap.put(section.getName(), section));
        ArrayList<ProtobufSystemInfo.Section> result = new ArrayList<ProtobufSystemInfo.Section>(sections.size());
        Arrays.stream(orderedNames).forEach(name -> {
            ProtobufSystemInfo.Section section = (ProtobufSystemInfo.Section)alphabeticalOrderedMap.remove(name);
            if (section != null) {
                result.add(section);
            }
        });
        result.addAll(alphabeticalOrderedMap.values());
        return result;
    }
}

