/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.analysis;

import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.AnalysisMode;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.analysis.AnalysisProperties;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;

@Immutable
public class DefaultAnalysisMode
implements AnalysisMode {
    private static final Logger LOG = Loggers.get(DefaultAnalysisMode.class);
    private static final String KEY_SCAN_ALL = "sonar.scanAllFiles";
    private final Map<String, String> analysisProps;
    private final GlobalAnalysisMode analysisMode;
    private boolean scanAllFiles;

    public DefaultAnalysisMode(AnalysisProperties props, GlobalAnalysisMode analysisMode) {
        this.analysisMode = analysisMode;
        this.analysisProps = props.properties();
        this.load();
        this.printFlags();
    }

    public boolean scanAllFiles() {
        return this.scanAllFiles;
    }

    private void printFlags() {
        if (!this.scanAllFiles) {
            LOG.info("Scanning only changed files");
        }
    }

    private void load() {
        String scanAllStr = this.analysisProps.get(KEY_SCAN_ALL);
        this.scanAllFiles = !this.analysisMode.isIssues() || "true".equals(scanAllStr);
    }

    public boolean isPreview() {
        return this.analysisMode.isPreview();
    }

    public boolean isIssues() {
        return this.analysisMode.isIssues();
    }

    public boolean isPublish() {
        return this.analysisMode.isPublish();
    }
}

