/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.util.Map;
import java.util.Objects;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class DroppedPropertyChecker {
    private static final Logger LOG = Loggers.get(DroppedPropertyChecker.class);
    private final Map<String, String> settings;
    private final Map<String, String> properties;

    public DroppedPropertyChecker(Map<String, String> properties, Map<String, String> droppedPropertiesAndMsg) {
        this.settings = Objects.requireNonNull(properties);
        this.properties = Objects.requireNonNull(droppedPropertiesAndMsg);
    }

    public void checkDroppedProperties() {
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (!this.settings.containsKey(entry.getKey())) continue;
            LOG.warn("Property '{}' is not supported any more. {}", (Object)entry.getKey(), (Object)entry.getValue());
        }
    }
}

