/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.time.Clock;
import java.util.List;
import java.util.Map;
import org.sonar.api.Plugin;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarQubeVersion;
import org.sonar.api.internal.ApiVersion;
import org.sonar.api.internal.SonarRuntimeImpl;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.UriReader;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.core.platform.PluginClassloaderFactory;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginLoader;
import org.sonar.core.platform.PluginRepository;
import org.sonar.core.util.DefaultHttpDownloader;
import org.sonar.core.util.UuidFactoryImpl;
import org.sonar.scanner.bootstrap.ExtensionInstaller;
import org.sonar.scanner.bootstrap.FileCacheProvider;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.bootstrap.GlobalConfigurationProvider;
import org.sonar.scanner.bootstrap.GlobalProperties;
import org.sonar.scanner.bootstrap.GlobalTempFolderProvider;
import org.sonar.scanner.bootstrap.MutableGlobalSettings;
import org.sonar.scanner.bootstrap.PluginInstaller;
import org.sonar.scanner.bootstrap.ScannerPluginInstaller;
import org.sonar.scanner.bootstrap.ScannerPluginJarExploder;
import org.sonar.scanner.bootstrap.ScannerPluginPredicate;
import org.sonar.scanner.bootstrap.ScannerPluginRepository;
import org.sonar.scanner.bootstrap.ScannerWsClientProvider;
import org.sonar.scanner.platform.DefaultServer;
import org.sonar.scanner.repository.DefaultMetricsRepositoryLoader;
import org.sonar.scanner.repository.MetricsRepositoryLoader;
import org.sonar.scanner.repository.MetricsRepositoryProvider;
import org.sonar.scanner.repository.settings.DefaultSettingsLoader;
import org.sonar.scanner.repository.settings.SettingsLoader;
import org.sonar.scanner.storage.StoragesManager;
import org.sonar.scanner.task.TaskContainer;

public class GlobalContainer
extends ComponentContainer {
    private static final Logger LOG = Loggers.get(GlobalContainer.class);
    private final Map<String, String> bootstrapProperties;

    private GlobalContainer(Map<String, String> bootstrapProperties) {
        this.bootstrapProperties = bootstrapProperties;
    }

    public static GlobalContainer create(Map<String, String> bootstrapProperties, List<?> extensions) {
        GlobalContainer container = new GlobalContainer(bootstrapProperties);
        container.add(new Object[]{extensions});
        return container;
    }

    protected void doBeforeStart() {
        GlobalProperties bootstrapProps = new GlobalProperties(this.bootstrapProperties);
        GlobalAnalysisMode globalMode = new GlobalAnalysisMode(bootstrapProps);
        this.add(new Object[]{bootstrapProps});
        this.add(new Object[]{globalMode});
        this.addBootstrapComponents();
    }

    private void addBootstrapComponents() {
        Version apiVersion = ApiVersion.load((System2)System2.INSTANCE);
        this.add(new Object[]{ScannerPluginRepository.class, PluginLoader.class, PluginClassloaderFactory.class, ScannerPluginJarExploder.class, ScannerPluginPredicate.class, ExtensionInstaller.class, new SonarQubeVersion(apiVersion), SonarRuntimeImpl.forSonarQube((Version)apiVersion, (SonarQubeSide)SonarQubeSide.SCANNER), StoragesManager.class, MutableGlobalSettings.class, new GlobalConfigurationProvider(), new ScannerWsClientProvider(), DefaultServer.class, new GlobalTempFolderProvider(), DefaultHttpDownloader.class, UriReader.class, new FileCacheProvider(), System2.INSTANCE, Clock.systemDefaultZone(), new MetricsRepositoryProvider(), UuidFactoryImpl.INSTANCE});
        this.addIfMissing(ScannerPluginInstaller.class, PluginInstaller.class);
        this.addIfMissing(DefaultSettingsLoader.class, SettingsLoader.class);
        this.addIfMissing(DefaultMetricsRepositoryLoader.class, MetricsRepositoryLoader.class);
    }

    protected void doAfterStart() {
        this.installPlugins();
    }

    private void installPlugins() {
        PluginRepository pluginRepository = (PluginRepository)this.getComponentByType(PluginRepository.class);
        for (PluginInfo pluginInfo : pluginRepository.getPluginInfos()) {
            Plugin instance = pluginRepository.getPluginInstance(pluginInfo.getKey());
            this.addExtension(pluginInfo, instance);
        }
    }

    public void executeTask(Map<String, String> taskProperties, Object ... components) {
        long startTime = System.currentTimeMillis();
        new TaskContainer(this, taskProperties, components).execute();
        LOG.info("Task total time: {}", (Object)GlobalContainer.formatTime(System.currentTimeMillis() - startTime));
    }

    static String formatTime(long time) {
        long h = time / 3600000L;
        long m = (time - h * 60L * 60L * 1000L) / 60000L;
        long s = (time - h * 60L * 60L * 1000L - m * 60L * 1000L) / 1000L;
        long ms = time % 1000L;
        String format = h > 0L ? "%1$d:%2$02d:%3$02d.%4$03d s" : (m > 0L ? "%2$d:%3$02d.%4$03d s" : "%3$d.%4$03d s");
        return String.format(format, h, m, s, ms);
    }
}

