/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;

@ScannerSide
public class ScannerPluginPredicate
implements Predicate<String> {
    private static final Logger LOG = Loggers.get(ScannerPluginPredicate.class);
    private static final String BUILDBREAKER_PLUGIN_KEY = "buildbreaker";
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private final Set<String> whites = new HashSet<String>();
    private final Set<String> blacks = new HashSet<String>();
    private final GlobalAnalysisMode mode;

    public ScannerPluginPredicate(Configuration settings, GlobalAnalysisMode mode) {
        this.mode = mode;
        if (mode.isPreview() || mode.isIssues()) {
            this.whites.addAll(ScannerPluginPredicate.propertyValues(settings, "sonar.preview.includePlugins", ""));
            this.blacks.addAll(ScannerPluginPredicate.propertyValues(settings, "sonar.preview.excludePlugins", "devcockpit,pdfreport,governance,ldap,authaad,authgithub,authbitbucket,googleanalytics"));
        }
        if (!this.whites.isEmpty()) {
            LOG.info("Include plugins: " + COMMA_JOINER.join(this.whites));
        }
        if (!this.blacks.isEmpty()) {
            LOG.info("Exclude plugins: " + COMMA_JOINER.join(this.blacks));
        }
    }

    public boolean apply(@Nonnull String pluginKey) {
        if (BUILDBREAKER_PLUGIN_KEY.equals(pluginKey) && this.mode.isPreview()) {
            LOG.info("Build Breaker plugin is no more supported in preview mode");
            return false;
        }
        if (this.whites.isEmpty()) {
            return this.blacks.isEmpty() || !this.blacks.contains(pluginKey);
        }
        return this.whites.contains(pluginKey);
    }

    Set<String> getWhites() {
        return this.whites;
    }

    Set<String> getBlacks() {
        return this.blacks;
    }

    private static List<String> propertyValues(Configuration settings, String key, String defaultValue) {
        String s = settings.get(key).orElse(defaultValue);
        return StreamSupport.stream(Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)s).spliterator(), false).collect(Collectors.toList());
    }
}

