/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.picocontainer.Startable;
import org.sonar.api.Plugin;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginLoader;
import org.sonar.core.platform.PluginRepository;
import org.sonar.scanner.bootstrap.PluginInstaller;
import org.sonar.scanner.bootstrap.ScannerPlugin;

public class ScannerPluginRepository
implements PluginRepository,
Startable {
    private static final Logger LOG = Loggers.get(ScannerPluginRepository.class);
    private final PluginInstaller installer;
    private final PluginLoader loader;
    private Map<String, Plugin> pluginInstancesByKeys;
    private Map<String, ScannerPlugin> pluginsByKeys;
    private Map<ClassLoader, String> keysByClassLoader;

    public ScannerPluginRepository(PluginInstaller installer, PluginLoader loader) {
        this.installer = installer;
        this.loader = loader;
    }

    public void start() {
        this.pluginsByKeys = new HashMap<String, ScannerPlugin>(this.installer.installRemotes());
        this.pluginInstancesByKeys = new HashMap<String, Plugin>(this.loader.load(this.pluginsByKeys.values().stream().map(ScannerPlugin::getInfo).collect(Collectors.toMap(PluginInfo::getKey, Function.identity()))));
        for (Object[] objectArray : this.installer.installLocals()) {
            String pluginKey = (String)objectArray[0];
            PluginInfo pluginInfo = new PluginInfo(pluginKey);
            this.pluginsByKeys.put(pluginKey, new ScannerPlugin(pluginInfo.getKey(), (Long)objectArray[2], pluginInfo));
            this.pluginInstancesByKeys.put(pluginKey, (Plugin)objectArray[1]);
        }
        this.keysByClassLoader = new HashMap<ClassLoader, String>();
        for (Map.Entry entry : this.pluginInstancesByKeys.entrySet()) {
            this.keysByClassLoader.put(((Plugin)entry.getValue()).getClass().getClassLoader(), (String)entry.getKey());
        }
        this.logPlugins();
    }

    @CheckForNull
    public String getPluginKey(ClassLoader cl) {
        return this.keysByClassLoader.get(cl);
    }

    private void logPlugins() {
        if (this.pluginsByKeys.isEmpty()) {
            LOG.debug("No plugins loaded");
        } else {
            LOG.debug("Plugins:");
            for (ScannerPlugin p : this.pluginsByKeys.values()) {
                LOG.debug("  * {} {} ({})", new Object[]{p.getName(), p.getVersion(), p.getKey()});
            }
        }
    }

    public void stop() {
        this.loader.unload(this.pluginInstancesByKeys.values());
        this.pluginInstancesByKeys.clear();
        this.pluginsByKeys.clear();
        this.keysByClassLoader.clear();
    }

    public Map<String, ScannerPlugin> getPluginsByKey() {
        return this.pluginsByKeys;
    }

    public Collection<PluginInfo> getPluginInfos() {
        return this.pluginsByKeys.values().stream().map(ScannerPlugin::getInfo).collect(Collectors.toList());
    }

    public PluginInfo getPluginInfo(String key) {
        ScannerPlugin info = this.pluginsByKeys.get(key);
        Preconditions.checkState((info != null ? 1 : 0) != 0, (String)"Plugin [%s] does not exist", (Object[])new Object[]{key});
        return info.getInfo();
    }

    public Plugin getPluginInstance(String key) {
        Plugin instance = this.pluginInstancesByKeys.get(key);
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (String)"Plugin [%s] does not exist", (Object[])new Object[]{key});
        return instance;
    }

    public boolean hasPlugin(String key) {
        return this.pluginsByKeys.containsKey(key);
    }
}

