/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.config;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.Encryption;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;

@Immutable
public abstract class DefaultConfiguration
implements Configuration {
    private static final Logger LOG = Loggers.get(DefaultConfiguration.class);
    private final PropertyDefinitions definitions;
    private final Encryption encryption;
    private final GlobalAnalysisMode mode;
    private final Map<String, String> properties;

    public DefaultConfiguration(PropertyDefinitions propertyDefinitions, Encryption encryption, GlobalAnalysisMode mode, Map<String, String> props) {
        this.definitions = Objects.requireNonNull(propertyDefinitions);
        this.encryption = encryption;
        this.mode = mode;
        this.properties = DefaultConfiguration.unmodifiableMapWithTrimmedValues(this.definitions, props);
    }

    protected static Map<String, String> unmodifiableMapWithTrimmedValues(PropertyDefinitions definitions, Map<String, String> props) {
        HashMap map = new HashMap(props.size());
        props.forEach((k, v) -> {
            String validKey = definitions.validKey(k);
            map.put(validKey, StringUtils.trim((String)v));
        });
        return Collections.unmodifiableMap(map);
    }

    public GlobalAnalysisMode getMode() {
        return this.mode;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public PropertyDefinitions getDefinitions() {
        return this.definitions;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean hasKey(String key) {
        return this.properties.containsKey(key);
    }

    public Optional<String> get(String key) {
        String effectiveKey = this.definitions.validKey(key);
        PropertyDefinition def = this.definitions.get(effectiveKey);
        if (def != null && (def.multiValues() || !def.fields().isEmpty())) {
            LOG.warn("Access to the multi-values/property set property '{}' should be made using 'getStringArray' method. The SonarQube plugin using this property should be updated.", (Object)key);
        }
        return this.getInternal(effectiveKey);
    }

    public String[] getStringArray(String key) {
        Optional<String> value;
        String effectiveKey = this.definitions.validKey(key);
        PropertyDefinition def = this.definitions.get(effectiveKey);
        if (def != null && !def.multiValues() && def.fields().isEmpty()) {
            LOG.warn("Property '{}' is not declared as multi-values/property set but was read using 'getStringArray' method. The SonarQube plugin declaring this property should be updated.", (Object)key);
        }
        if ((value = this.getInternal(effectiveKey)).isPresent()) {
            return DefaultConfiguration.parseAsCsv(effectiveKey, value.get());
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] parseAsCsv(String key, String value) {
        ArrayList<String> result = new ArrayList<String>();
        try (CSVParser csvParser = CSVFormat.RFC4180.withHeader(new String[]{null}).withIgnoreEmptyLines().withIgnoreSurroundingSpaces().parse((Reader)new StringReader(value));){
            List records = csvParser.getRecords();
            if (records.isEmpty()) {
                String[] stringArray = ArrayUtils.EMPTY_STRING_ARRAY;
                return stringArray;
            }
            DefaultConfiguration.processRecords(result, records);
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("Property: '" + key + "' doesn't contain a valid CSV value: '" + value + "'", e);
        }
    }

    private static void processRecords(List<String> result, List<CSVRecord> records) {
        for (CSVRecord csvRecord : records) {
            String next;
            Iterator it = csvRecord.iterator();
            if (!result.isEmpty() && !(next = (String)it.next()).isEmpty()) {
                int lastItemIdx = result.size() - 1;
                String previous = result.get(lastItemIdx);
                if (previous.isEmpty()) {
                    result.set(lastItemIdx, next);
                } else {
                    result.set(lastItemIdx, previous + "\n" + next);
                }
            }
            it.forEachRemaining(result::add);
        }
    }

    private Optional<String> getInternal(String key) {
        if (this.mode.isIssues() && key.endsWith(".secured") && !key.contains(".license")) {
            throw MessageException.of((String)("Access to the secured property '" + key + "' is not possible in issues mode. The SonarQube plugin which requires this property must be deactivated in issues mode."));
        }
        Optional<String> value = Optional.ofNullable(this.properties.get(key));
        if (!value.isPresent()) {
            return Optional.ofNullable(this.definitions.getDefaultValue(key));
        }
        if (this.encryption.isEncrypted(value.get())) {
            try {
                return Optional.of(this.encryption.decrypt(value.get()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Fail to decrypt the property " + key + ". Please check your secret key.", e);
            }
        }
        return value;
    }
}

