/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.cpd.deprecated;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.batch.CpdMapping;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.duplications.internal.pmd.TokenizerBridge;
import org.sonar.scanner.cpd.deprecated.CpdBlockIndexer;
import org.sonar.scanner.cpd.deprecated.CpdMappings;
import org.sonar.scanner.cpd.index.SonarCpdBlockIndex;

public class DefaultCpdBlockIndexer
extends CpdBlockIndexer {
    private static final Logger LOG = Loggers.get(DefaultCpdBlockIndexer.class);
    private final CpdMappings mappings;
    private final FileSystem fs;
    private final Configuration settings;
    private final SonarCpdBlockIndex index;

    public DefaultCpdBlockIndexer(CpdMappings mappings, FileSystem fs, Configuration settings, SonarCpdBlockIndex index) {
        this.mappings = mappings;
        this.fs = fs;
        this.settings = settings;
        this.index = index;
    }

    @Override
    public boolean isLanguageSupported(String language) {
        return true;
    }

    @Override
    public void index(String languageKey) {
        CpdMapping mapping = this.mappings.getMapping(languageKey);
        if (mapping == null) {
            LOG.debug("No CpdMapping for language {}", (Object)languageKey);
            return;
        }
        String[] cpdExclusions = this.settings.getStringArray("sonar.cpd.exclusions");
        this.logExclusions(cpdExclusions);
        FilePredicates p = this.fs.predicates();
        ArrayList sourceFiles = Lists.newArrayList((Iterable)this.fs.inputFiles(p.and(new FilePredicate[]{p.hasType(InputFile.Type.MAIN), p.hasLanguage(languageKey), p.doesNotMatchPathPatterns(cpdExclusions)})));
        if (sourceFiles.isEmpty()) {
            return;
        }
        this.populateIndex(languageKey, sourceFiles, mapping);
    }

    private void populateIndex(String languageKey, List<InputFile> sourceFiles, CpdMapping mapping) {
        TokenizerBridge bridge = new TokenizerBridge(mapping.getTokenizer(), this.getBlockSize(languageKey));
        for (InputFile inputFile : sourceFiles) {
            List blocks;
            if (this.index.isIndexed(inputFile)) continue;
            LOG.debug("Populating index from {}", (Object)inputFile.absolutePath());
            String resourceEffectiveKey = ((DefaultInputFile)inputFile).key();
            try (InputStreamReader isr = new InputStreamReader(inputFile.inputStream(), inputFile.charset());){
                blocks = bridge.chunk(resourceEffectiveKey, inputFile.absolutePath(), (Reader)isr);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read content of file " + inputFile.absolutePath(), e);
            }
            this.index.insert(inputFile, blocks);
        }
    }

    @VisibleForTesting
    int getBlockSize(String languageKey) {
        return this.settings.getInt("sonar.cpd." + languageKey + ".minimumLines").orElse(DefaultCpdBlockIndexer.getDefaultBlockSize(languageKey));
    }

    @VisibleForTesting
    public static int getDefaultBlockSize(String languageKey) {
        if ("cobol".equals(languageKey)) {
            return 30;
        }
        if ("abap".equals(languageKey)) {
            return 20;
        }
        return 10;
    }
}

