/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.deprecated.perspectives;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.component.Perspective;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.core.component.ComponentKeys;
import org.sonar.scanner.deprecated.perspectives.PerspectiveBuilder;
import org.sonar.scanner.deprecated.perspectives.PerspectiveNotFoundException;
import org.sonar.scanner.scan.filesystem.InputComponentStore;

public class ScannerPerspectives
implements ResourcePerspectives {
    private final Map<Class<?>, PerspectiveBuilder<?>> builders = Maps.newHashMap();
    private final InputComponentStore componentStore;
    private final DefaultInputModule module;

    public ScannerPerspectives(PerspectiveBuilder[] builders, DefaultInputModule module, InputComponentStore componentStore) {
        this.componentStore = componentStore;
        this.module = module;
        for (PerspectiveBuilder builder : builders) {
            this.builders.put(builder.getPerspectiveClass(), builder);
        }
    }

    @CheckForNull
    public <P extends Perspective> P as(Class<P> perspectiveClass, Resource resource) {
        InputComponent component = this.componentStore.getByKey(this.getComponentKey(resource));
        if (component != null) {
            PerspectiveBuilder<P> builder = this.builderFor(perspectiveClass);
            return builder.loadPerspective(perspectiveClass, component);
        }
        return null;
    }

    private String getComponentKey(Resource r) {
        if (ResourceUtils.isProject((Resource)r) || ResourceUtils.isRootProject((Resource)r)) {
            return r.getKey();
        }
        return ComponentKeys.createEffectiveKey((String)this.module.key(), (Resource)r);
    }

    public <P extends Perspective> P as(Class<P> perspectiveClass, InputPath inputPath) {
        PerspectiveBuilder<P> builder = this.builderFor(perspectiveClass);
        return builder.loadPerspective(perspectiveClass, (InputComponent)inputPath);
    }

    private <T extends Perspective> PerspectiveBuilder<T> builderFor(Class<T> clazz) {
        PerspectiveBuilder<?> builder = this.builders.get(clazz);
        if (builder == null) {
            throw new PerspectiveNotFoundException("Perspective class is not registered: " + clazz);
        }
        return builder;
    }
}

