/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.genericcoverage;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.stream.Collectors;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.deprecated.test.TestPlanBuilder;
import org.sonar.scanner.genericcoverage.GenericTestExecutionReportParser;

public class GenericTestExecutionSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(GenericTestExecutionSensor.class);
    static final String REPORT_PATHS_PROPERTY_KEY = "sonar.testExecutionReportPaths";
    @Deprecated
    static final String OLD_UNIT_TEST_REPORT_PATHS_PROPERTY_KEY = "sonar.genericcoverage.unitTestReportPaths";
    private final TestPlanBuilder testPlanBuilder;

    public GenericTestExecutionSensor(TestPlanBuilder testPlanBuilder) {
        this.testPlanBuilder = testPlanBuilder;
    }

    public static ImmutableList<PropertyDefinition> properties() {
        return ImmutableList.of((Object)PropertyDefinition.builder((String)REPORT_PATHS_PROPERTY_KEY).name("Unit tests results report paths").description("List of comma-separated paths (absolute or relative) containing unit tests results report.").category("codeCoverage").onQualifiers("TRK", new String[0]).deprecatedKey(OLD_UNIT_TEST_REPORT_PATHS_PROPERTY_KEY).build());
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Generic Test Executions Report").onlyWhenConfiguration(conf -> conf.hasKey(REPORT_PATHS_PROPERTY_KEY));
    }

    public void execute(SensorContext context) {
        if (context.settings().hasKey(OLD_UNIT_TEST_REPORT_PATHS_PROPERTY_KEY)) {
            LOG.warn("Property '{}' is deprecated. Please use '{}' instead.", (Object)OLD_UNIT_TEST_REPORT_PATHS_PROPERTY_KEY, (Object)REPORT_PATHS_PROPERTY_KEY);
        }
        for (String reportPath : context.settings().getStringArray(REPORT_PATHS_PROPERTY_KEY)) {
            File reportFile = context.fileSystem().resolvePath(reportPath);
            LOG.info("Parsing {}", (Object)reportFile);
            GenericTestExecutionReportParser parser = new GenericTestExecutionReportParser(this.testPlanBuilder);
            parser.parse(reportFile, context);
            LOG.info("Imported test execution data for {} files", (Object)parser.numberOfMatchedFiles());
            int numberOfUnknownFiles = parser.numberOfUnknownFiles();
            if (numberOfUnknownFiles <= 0) continue;
            LOG.info("Test execution data ignored for {} unknown files, including:\n{}", (Object)numberOfUnknownFiles, (Object)parser.firstUnknownFiles().stream().collect(Collectors.joining("\n")));
        }
    }
}

