/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.index;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputComponentTree;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.measure.MetricFinder;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.File;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.scan.measure.MeasureCache;
import org.sonar.scanner.sensor.DefaultSensorStorage;

public class DefaultIndex {
    private final InputComponentStore componentStore;
    private final MeasureCache measureCache;
    private final MetricFinder metricFinder;
    private DefaultSensorStorage sensorStorage;
    private InputComponentTree tree;

    public DefaultIndex(InputComponentStore componentStore, InputComponentTree tree, MeasureCache measureCache, MetricFinder metricFinder) {
        this.componentStore = componentStore;
        this.tree = tree;
        this.measureCache = measureCache;
        this.metricFinder = metricFinder;
    }

    public void setCurrentStorage(DefaultSensorStorage sensorStorage) {
        this.sensorStorage = sensorStorage;
    }

    @CheckForNull
    public org.sonar.api.measures.Measure getMeasure(String key, Metric<?> metric) {
        return (org.sonar.api.measures.Measure)this.getMeasures(key, MeasuresFilters.metric(metric));
    }

    @CheckForNull
    public <M> M getMeasures(String key, MeasuresFilter<M> filter) {
        ArrayList unfiltered = new ArrayList();
        if (filter instanceof MeasuresFilters.MetricFilter) {
            DefaultMeasure<?> byMetric = this.measureCache.byMetric(key, ((MeasuresFilters.MetricFilter)filter).filterOnMetricKey());
            if (byMetric != null) {
                unfiltered.add(byMetric);
            }
        } else {
            for (DefaultMeasure<?> measure : this.measureCache.byComponentKey(key)) {
                unfiltered.add(measure);
            }
        }
        return (M)filter.filter((Collection)unfiltered.stream().map(DefaultIndex::toDeprecated).collect(Collectors.toList()));
    }

    private static org.sonar.api.measures.Measure toDeprecated(Measure<?> measure) {
        org.sonar.api.measures.Measure deprecatedMeasure = new org.sonar.api.measures.Measure((org.sonar.api.measures.Metric)measure.metric());
        DefaultIndex.setValueAccordingToMetricType(measure, deprecatedMeasure);
        return deprecatedMeasure;
    }

    private static void setValueAccordingToMetricType(Measure<?> measure, org.sonar.api.measures.Measure measureToSave) {
        Metric.ValueType deprecatedType = ((org.sonar.api.measures.Metric)measure.metric()).getType();
        switch (deprecatedType) {
            case BOOL: {
                measureToSave.setValue(Double.valueOf(Boolean.TRUE.equals(measure.value()) ? 1.0 : 0.0));
                break;
            }
            case INT: 
            case MILLISEC: 
            case WORK_DUR: 
            case FLOAT: 
            case PERCENT: 
            case RATING: {
                measureToSave.setValue(Double.valueOf(((Number)measure.value()).doubleValue()));
                break;
            }
            case STRING: 
            case LEVEL: 
            case DATA: 
            case DISTRIB: {
                measureToSave.setData((String)((Object)measure.value()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type :" + deprecatedType);
            }
        }
    }

    public org.sonar.api.measures.Measure addMeasure(String key, org.sonar.api.measures.Measure measure) {
        DefaultMeasure newMeasure;
        InputComponent component = this.componentStore.getByKey(key);
        if (component == null) {
            throw new IllegalStateException("Invalid component key: " + key);
        }
        if (DefaultSensorStorage.isDeprecatedMetric(measure.getMetricKey())) {
            return measure;
        }
        Metric metric = this.metricFinder.findByKey(measure.getMetricKey());
        if (metric == null) {
            throw new UnsupportedOperationException("Unknown metric: " + measure.getMetricKey());
        }
        if (Boolean.class.equals((Object)metric.valueType())) {
            newMeasure = new DefaultMeasure().forMetric((Metric)((org.sonar.api.measures.Metric)metric)).withValue((Serializable)Boolean.valueOf(measure.getValue() != 0.0));
        } else if (Integer.class.equals((Object)metric.valueType())) {
            newMeasure = new DefaultMeasure().forMetric((Metric)((org.sonar.api.measures.Metric)metric)).withValue((Serializable)Integer.valueOf(measure.getValue().intValue()));
        } else if (Double.class.equals((Object)metric.valueType())) {
            newMeasure = new DefaultMeasure().forMetric((Metric)((org.sonar.api.measures.Metric)metric)).withValue((Serializable)measure.getValue());
        } else if (String.class.equals((Object)metric.valueType())) {
            newMeasure = new DefaultMeasure().forMetric((Metric)((org.sonar.api.measures.Metric)metric)).withValue((Serializable)((Object)measure.getData()));
        } else if (Long.class.equals((Object)metric.valueType())) {
            newMeasure = new DefaultMeasure().forMetric((Metric)((org.sonar.api.measures.Metric)metric)).withValue((Serializable)Long.valueOf(measure.getValue().longValue()));
        } else {
            throw new UnsupportedOperationException("Unsupported type :" + metric.valueType());
        }
        this.sensorStorage.saveMeasure(component, newMeasure);
        return measure;
    }

    @CheckForNull
    public Resource getParent(String key) {
        InputComponent component = this.componentStore.getByKey(key);
        if (component == null) {
            return null;
        }
        InputComponent parent = this.tree.getParent(component);
        if (parent == null) {
            return null;
        }
        return this.toResource(parent);
    }

    public Collection<Resource> getChildren(String key) {
        InputComponent component = this.componentStore.getByKey(key);
        Collection children = this.tree.getChildren(component);
        return children.stream().map(this::toResource).collect(Collectors.toList());
    }

    public Resource toResource(InputComponent inputComponent) {
        Directory r;
        if (inputComponent instanceof InputDir) {
            r = Directory.create((String)((InputDir)inputComponent).relativePath());
        } else if (inputComponent instanceof InputFile) {
            r = File.create((String)((InputFile)inputComponent).relativePath());
        } else if (inputComponent instanceof InputModule) {
            r = new Project((DefaultInputModule)inputComponent);
        } else {
            throw new IllegalArgumentException("Unknow input path type: " + inputComponent);
        }
        return r;
    }

    @CheckForNull
    public Resource getResource(String key) {
        InputComponent component = this.componentStore.getByKey(key);
        if (component == null) {
            return null;
        }
        return this.toResource(component);
    }
}

