/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue;

import java.util.Collection;
import org.sonar.api.batch.ScannerSide;
import org.sonar.scanner.issue.tracking.TrackedIssue;
import org.sonar.scanner.storage.Storage;
import org.sonar.scanner.storage.Storages;

@ScannerSide
public class IssueCache {
    private final Storage<TrackedIssue> cache;

    public IssueCache(Storages caches) {
        this.cache = caches.createCache("issues");
    }

    public Iterable<TrackedIssue> byComponent(String componentKey) {
        return this.cache.values(componentKey);
    }

    public Iterable<TrackedIssue> all() {
        return this.cache.values();
    }

    public Collection<Object> componentKeys() {
        return this.cache.keySet();
    }

    public IssueCache put(TrackedIssue issue) {
        this.cache.put(issue.componentKey(), issue.key(), issue);
        return this;
    }

    public void clear(String componentKey) {
        this.cache.clear(componentKey);
    }
}

