/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue;

import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.issue.batch.IssueFilter;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilterChain;
import org.sonar.scanner.ProjectAnalysisInfo;
import org.sonar.scanner.issue.DefaultFilterableIssue;
import org.sonar.scanner.issue.DefaultIssueFilterChain;
import org.sonar.scanner.issue.DeprecatedIssueAdapterForFilter;
import org.sonar.scanner.issue.DeprecatedIssueFilterChain;
import org.sonar.scanner.protocol.output.ScannerReport;

@ScannerSide
public class IssueFilters {
    private final IssueFilterChain filterChain;
    private final IssueFilter[] deprecatedFilters;
    private final DefaultInputModule module;
    private final ProjectAnalysisInfo projectAnalysisInfo;

    public IssueFilters(DefaultInputModule module, ProjectAnalysisInfo projectAnalysisInfo, org.sonar.api.scan.issue.filter.IssueFilter[] exclusionFilters, IssueFilter[] filters) {
        this.module = module;
        this.filterChain = new DefaultIssueFilterChain(exclusionFilters);
        this.deprecatedFilters = filters;
        this.projectAnalysisInfo = projectAnalysisInfo;
    }

    public IssueFilters(DefaultInputModule module, ProjectAnalysisInfo projectAnalysisInfo, org.sonar.api.scan.issue.filter.IssueFilter[] filters) {
        this(module, projectAnalysisInfo, filters, new IssueFilter[0]);
    }

    public IssueFilters(DefaultInputModule module, ProjectAnalysisInfo projectAnalysisInfo, IssueFilter[] deprecatedFilters) {
        this(module, projectAnalysisInfo, new org.sonar.api.scan.issue.filter.IssueFilter[0], deprecatedFilters);
    }

    public IssueFilters(DefaultInputModule module, ProjectAnalysisInfo projectAnalysisInfo) {
        this(module, projectAnalysisInfo, new org.sonar.api.scan.issue.filter.IssueFilter[0], new IssueFilter[0]);
    }

    public boolean accept(String componentKey, ScannerReport.Issue rawIssue) {
        DefaultFilterableIssue fIssue = new DefaultFilterableIssue((InputModule)this.module, this.projectAnalysisInfo, rawIssue, componentKey);
        if (this.filterChain.accept((FilterableIssue)fIssue)) {
            return this.acceptDeprecated(componentKey, rawIssue);
        }
        return false;
    }

    public boolean acceptDeprecated(String componentKey, ScannerReport.Issue rawIssue) {
        DeprecatedIssueAdapterForFilter issue = new DeprecatedIssueAdapterForFilter(this.module, this.projectAnalysisInfo, rawIssue, componentKey);
        return new DeprecatedIssueFilterChain(this.deprecatedFilters).accept(issue);
    }
}

