/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.rule.RuleKey;
import org.sonar.core.util.Uuids;
import org.sonar.scanner.issue.tracking.SourceHashHolder;
import org.sonar.scanner.issue.tracking.TrackedIssue;
import org.sonar.scanner.protocol.input.ScannerInput;
import org.sonar.scanner.protocol.output.ScannerReport;

public class IssueTransformer {
    private IssueTransformer() {
    }

    public static TrackedIssue toTrackedIssue(ScannerInput.ServerIssue serverIssue, String componentKey) {
        TrackedIssue issue = new TrackedIssue();
        issue.setKey(serverIssue.getKey());
        issue.setStatus(serverIssue.getStatus());
        issue.setResolution(serverIssue.hasResolution() ? serverIssue.getResolution() : null);
        issue.setMessage(serverIssue.hasMsg() ? serverIssue.getMsg() : null);
        issue.setStartLine(serverIssue.hasLine() ? Integer.valueOf(serverIssue.getLine()) : null);
        issue.setEndLine(serverIssue.hasLine() ? Integer.valueOf(serverIssue.getLine()) : null);
        issue.setSeverity(serverIssue.getSeverity().name());
        issue.setAssignee(serverIssue.hasAssigneeLogin() ? serverIssue.getAssigneeLogin() : null);
        issue.setComponentKey(componentKey);
        issue.setCreationDate(new Date(serverIssue.getCreationDate()));
        issue.setRuleKey(RuleKey.of((String)serverIssue.getRuleRepository(), (String)serverIssue.getRuleKey()));
        issue.setNew(false);
        return issue;
    }

    public static void close(TrackedIssue issue) {
        issue.setStatus("CLOSED");
        issue.setStartLine(null);
        issue.setEndLine(null);
        issue.setResolution("FIXED");
    }

    public static void resolveRemove(TrackedIssue issue) {
        issue.setStatus("CLOSED");
        issue.setStartLine(null);
        issue.setEndLine(null);
        issue.setResolution("REMOVED");
    }

    public static Collection<TrackedIssue> toTrackedIssue(InputComponent component, Collection<ScannerReport.Issue> rawIssues, @Nullable SourceHashHolder hashes) {
        ArrayList<TrackedIssue> issues = new ArrayList<TrackedIssue>(rawIssues.size());
        for (ScannerReport.Issue issue : rawIssues) {
            issues.add(IssueTransformer.toTrackedIssue(component, issue, hashes));
        }
        return issues;
    }

    public static TrackedIssue toTrackedIssue(InputComponent component, ScannerReport.Issue rawIssue, @Nullable SourceHashHolder hashes) {
        RuleKey ruleKey = RuleKey.of((String)rawIssue.getRuleRepository(), (String)rawIssue.getRuleKey());
        Preconditions.checkNotNull((Object)component.key(), (Object)"Component key must be set");
        Preconditions.checkNotNull((Object)ruleKey, (Object)"Rule key must be set");
        TrackedIssue issue = new TrackedIssue(hashes != null ? hashes.getHashedSource() : null);
        issue.setKey(Uuids.createFast());
        issue.setComponentKey(component.key());
        issue.setRuleKey(ruleKey);
        issue.setGap(rawIssue.getGap() != 0.0 ? Double.valueOf(rawIssue.getGap()) : null);
        issue.setSeverity(rawIssue.getSeverity().name());
        issue.setMessage(StringUtils.trimToNull((String)rawIssue.getMsg()));
        issue.setResolution(null);
        issue.setStatus("OPEN");
        issue.setNew(true);
        if (rawIssue.hasTextRange()) {
            ScannerReport.TextRange r = rawIssue.getTextRange();
            issue.setStartLine(r.getStartLine());
            issue.setStartLineOffset(r.getStartOffset());
            issue.setEndLine(r.getEndLine());
            issue.setEndLineOffset(r.getEndOffset());
        }
        return issue;
    }
}

