/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue;

import com.google.common.base.Strings;
import javax.annotation.concurrent.ThreadSafe;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.issue.IssueFilters;
import org.sonar.scanner.protocol.Constants;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.report.ReportPublisher;

@ThreadSafe
public class ModuleIssues {
    private final ActiveRules activeRules;
    private final Rules rules;
    private final IssueFilters filters;
    private final ReportPublisher reportPublisher;

    public ModuleIssues(ActiveRules activeRules, Rules rules, IssueFilters filters, ReportPublisher reportPublisher) {
        this.activeRules = activeRules;
        this.rules = rules;
        this.filters = filters;
        this.reportPublisher = reportPublisher;
    }

    public boolean initAndAddIssue(Issue issue) {
        DefaultInputComponent inputComponent = (DefaultInputComponent)issue.primaryLocation().inputComponent();
        Rule rule = this.validateRule(issue);
        ActiveRule activeRule = this.activeRules.find(issue.ruleKey());
        if (activeRule == null) {
            return false;
        }
        ScannerReport.Issue rawIssue = ModuleIssues.createReportIssue(issue, inputComponent.batchId(), rule.name(), activeRule.severity());
        if (this.filters.accept(inputComponent.key(), rawIssue)) {
            this.write(inputComponent.batchId(), rawIssue);
            return true;
        }
        return false;
    }

    private static ScannerReport.Issue createReportIssue(Issue issue, int componentRef, String ruleName, String activeRuleSeverity) {
        Double gap;
        String primaryMessage = Strings.isNullOrEmpty((String)issue.primaryLocation().message()) ? ruleName : issue.primaryLocation().message();
        Severity overriddenSeverity = issue.overriddenSeverity();
        Constants.Severity severity = overriddenSeverity != null ? Constants.Severity.valueOf((String)overriddenSeverity.name()) : Constants.Severity.valueOf((String)activeRuleSeverity);
        ScannerReport.Issue.Builder builder = ScannerReport.Issue.newBuilder();
        ScannerReport.IssueLocation.Builder locationBuilder = ScannerReport.IssueLocation.newBuilder();
        ScannerReport.TextRange.Builder textRangeBuilder = ScannerReport.TextRange.newBuilder();
        builder.setSeverity(severity);
        builder.setRuleRepository(issue.ruleKey().repository());
        builder.setRuleKey(issue.ruleKey().rule());
        builder.setMsg(primaryMessage);
        locationBuilder.setMsg(primaryMessage);
        locationBuilder.setComponentRef(componentRef);
        TextRange primaryTextRange = issue.primaryLocation().textRange();
        if (primaryTextRange != null) {
            builder.setTextRange(ModuleIssues.toProtobufTextRange(textRangeBuilder, primaryTextRange));
        }
        if ((gap = issue.gap()) != null) {
            builder.setGap(gap.doubleValue());
        }
        ModuleIssues.applyFlows(componentRef, builder, locationBuilder, textRangeBuilder, issue);
        return builder.build();
    }

    private static void applyFlows(int componentRef, ScannerReport.Issue.Builder builder, ScannerReport.IssueLocation.Builder locationBuilder, ScannerReport.TextRange.Builder textRangeBuilder, Issue issue) {
        ScannerReport.Flow.Builder flowBuilder = ScannerReport.Flow.newBuilder();
        for (Issue.Flow flow : issue.flows()) {
            if (flow.locations().isEmpty()) {
                return;
            }
            flowBuilder.clear();
            for (IssueLocation location : flow.locations()) {
                TextRange textRange;
                int locationComponentRef = ((DefaultInputComponent)location.inputComponent()).batchId();
                if (locationComponentRef != componentRef) continue;
                locationBuilder.clear();
                locationBuilder.setComponentRef(locationComponentRef);
                String message = location.message();
                if (message != null) {
                    locationBuilder.setMsg(message);
                }
                if ((textRange = location.textRange()) != null) {
                    locationBuilder.setTextRange(ModuleIssues.toProtobufTextRange(textRangeBuilder, textRange));
                }
                flowBuilder.addLocation(locationBuilder.build());
            }
            builder.addFlow(flowBuilder.build());
        }
    }

    private static ScannerReport.TextRange toProtobufTextRange(ScannerReport.TextRange.Builder textRangeBuilder, TextRange primaryTextRange) {
        textRangeBuilder.clear();
        textRangeBuilder.setStartLine(primaryTextRange.start().line());
        textRangeBuilder.setStartOffset(primaryTextRange.start().lineOffset());
        textRangeBuilder.setEndLine(primaryTextRange.end().line());
        textRangeBuilder.setEndOffset(primaryTextRange.end().lineOffset());
        return textRangeBuilder.build();
    }

    private Rule validateRule(Issue issue) {
        RuleKey ruleKey = issue.ruleKey();
        Rule rule = this.rules.find(ruleKey);
        if (rule == null) {
            throw MessageException.of((String)String.format("The rule '%s' does not exist.", ruleKey));
        }
        if (Strings.isNullOrEmpty((String)rule.name()) && Strings.isNullOrEmpty((String)issue.primaryLocation().message())) {
            throw MessageException.of((String)String.format("The rule '%s' has no name and the related issue has no message.", ruleKey));
        }
        return rule;
    }

    public void write(int batchId, ScannerReport.Issue rawIssue) {
        this.reportPublisher.getWriter().appendComponentIssue(batchId, rawIssue);
    }
}

