/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore.pattern;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.config.Configuration;
import org.sonar.scanner.issue.ignore.pattern.IssuePattern;
import org.sonar.scanner.issue.ignore.pattern.LineRange;
import org.sonar.scanner.issue.ignore.pattern.PatternDecoder;

@ScannerSide
public abstract class AbstractPatternInitializer {
    private Configuration settings;
    private List<IssuePattern> multicriteriaPatterns;

    protected AbstractPatternInitializer(Configuration settings) {
        this.settings = settings;
        this.initPatterns();
    }

    protected Configuration getSettings() {
        return this.settings;
    }

    public List<IssuePattern> getMulticriteriaPatterns() {
        return this.multicriteriaPatterns;
    }

    public boolean hasConfiguredPatterns() {
        return this.hasMulticriteriaPatterns();
    }

    public boolean hasMulticriteriaPatterns() {
        return !this.multicriteriaPatterns.isEmpty();
    }

    @VisibleForTesting
    protected final void initPatterns() {
        this.multicriteriaPatterns = new ArrayList<IssuePattern>();
        for (String id : this.settings.getStringArray(this.getMulticriteriaConfigurationKey())) {
            String propPrefix = this.getMulticriteriaConfigurationKey() + "." + id + ".";
            String resourceKeyPattern = this.settings.get(propPrefix + "resourceKey").orElse(null);
            String ruleKeyPattern = this.settings.get(propPrefix + "ruleKey").orElse(null);
            String lineRange = "*";
            Object[] fields = new String[]{resourceKeyPattern, ruleKeyPattern, lineRange};
            PatternDecoder.checkRegularLineConstraints(StringUtils.join((Object[])fields, (String)","), (String[])fields);
            Set<LineRange> rangeOfLines = PatternDecoder.decodeRangeOfLines((String)MoreObjects.firstNonNull((Object)lineRange, (Object)"*"));
            IssuePattern pattern = new IssuePattern((String)MoreObjects.firstNonNull((Object)resourceKeyPattern, (Object)"*"), (String)MoreObjects.firstNonNull((Object)ruleKeyPattern, (Object)"*"), rangeOfLines);
            this.multicriteriaPatterns.add(pattern);
        }
    }

    protected abstract String getMulticriteriaConfigurationKey();
}

