/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.tracking;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.rule.RuleKey;
import org.sonar.core.issue.tracking.Trackable;
import org.sonar.scanner.issue.tracking.FileHashes;

public class TrackedIssue
implements Trackable,
Serializable {
    private static final long serialVersionUID = -1755017079070964287L;
    private RuleKey ruleKey;
    private String key;
    private String severity;
    private Integer startLine;
    private Integer startLineOffset;
    private Integer endLine;
    private Integer endLineOffset;
    private Double gap;
    private boolean isNew;
    private Date creationDate;
    private String resolution;
    private String status;
    private String assignee;
    private String componentKey;
    private String message;
    private transient FileHashes hashes;

    public TrackedIssue() {
        this.hashes = null;
    }

    public TrackedIssue(@Nullable FileHashes hashes) {
        this.hashes = hashes;
    }

    @CheckForNull
    public String getLineHash() {
        if (this.getLine() == null || this.hashes == null) {
            return null;
        }
        int line = this.getLine();
        Preconditions.checkState((line <= this.hashes.length() ? 1 : 0) != 0, (String)"Invalid line number for issue %s. File has only %s line(s)", (Object[])new Object[]{this, this.hashes.length()});
        return this.hashes.getHash(line);
    }

    public String getMessage() {
        return this.message;
    }

    public TrackedIssue setMessage(String message) {
        this.message = message;
        return this;
    }

    public String componentKey() {
        return this.componentKey;
    }

    public TrackedIssue setComponentKey(String componentKey) {
        this.componentKey = componentKey;
        return this;
    }

    public String key() {
        return this.key;
    }

    public Integer startLine() {
        return this.startLine;
    }

    public Integer getLine() {
        return this.startLine;
    }

    public TrackedIssue setStartLine(Integer startLine) {
        this.startLine = startLine;
        return this;
    }

    public Integer startLineOffset() {
        return this.startLineOffset;
    }

    public TrackedIssue setStartLineOffset(Integer startLineOffset) {
        this.startLineOffset = startLineOffset;
        return this;
    }

    public Integer endLine() {
        return this.endLine;
    }

    public TrackedIssue setEndLine(Integer endLine) {
        this.endLine = endLine;
        return this;
    }

    public Integer endLineOffset() {
        return this.endLineOffset;
    }

    public TrackedIssue setEndLineOffset(Integer endLineOffset) {
        this.endLineOffset = endLineOffset;
        return this;
    }

    public TrackedIssue setKey(String key) {
        this.key = key;
        return this;
    }

    public String assignee() {
        return this.assignee;
    }

    public TrackedIssue setAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public String resolution() {
        return this.resolution;
    }

    public TrackedIssue setResolution(String resolution) {
        this.resolution = resolution;
        return this;
    }

    public String status() {
        return this.status;
    }

    public TrackedIssue setStatus(String status) {
        this.status = status;
        return this;
    }

    public RuleKey getRuleKey() {
        return this.ruleKey;
    }

    public String getStatus() {
        return this.status;
    }

    public String severity() {
        return this.severity;
    }

    public Double gap() {
        return this.gap;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public TrackedIssue setNew(boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    public Date creationDate() {
        return this.creationDate;
    }

    public TrackedIssue setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public TrackedIssue setRuleKey(RuleKey ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    public TrackedIssue setSeverity(String severity) {
        this.severity = severity;
        return this;
    }

    public TrackedIssue setGap(Double gap) {
        this.gap = gap;
        return this;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrackedIssue other = (TrackedIssue)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

