/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.mediumtest;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.AnalysisMode;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.core.util.CloseableIterator;
import org.sonar.scanner.issue.IssueCache;
import org.sonar.scanner.issue.tracking.TrackedIssue;
import org.sonar.scanner.mediumtest.ScanTaskObserver;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportReader;
import org.sonar.scanner.report.ReportPublisher;
import org.sonar.scanner.report.ScannerReportUtils;
import org.sonar.scanner.scan.ProjectScanContainer;
import org.sonar.scanner.scan.filesystem.InputComponentStore;

public class TaskResult
implements ScanTaskObserver {
    private static final Logger LOG = LoggerFactory.getLogger(TaskResult.class);
    private List<TrackedIssue> issues = new ArrayList<TrackedIssue>();
    private Map<String, InputFile> inputFiles = new HashMap<String, InputFile>();
    private Map<String, ScannerReport.Component> reportComponents = new HashMap<String, ScannerReport.Component>();
    private Map<String, InputDir> inputDirs = new HashMap<String, InputDir>();
    private ScannerReportReader reader;

    @Override
    public void scanTaskCompleted(ProjectScanContainer container) {
        LOG.info("Store analysis results in memory for later assertions in medium test");
        for (TrackedIssue issue : ((IssueCache)container.getComponentByType(IssueCache.class)).all()) {
            this.issues.add(issue);
        }
        ReportPublisher reportPublisher = (ReportPublisher)container.getComponentByType(ReportPublisher.class);
        this.reader = new ScannerReportReader(reportPublisher.getReportDir().toFile());
        if (!((AnalysisMode)container.getComponentByType(AnalysisMode.class)).isIssues()) {
            ScannerReport.Metadata readMetadata = this.getReportReader().readMetadata();
            int rootComponentRef = readMetadata.getRootComponentRef();
            this.storeReportComponents(rootComponentRef, null);
        }
        this.storeFs(container);
    }

    private void storeReportComponents(int componentRef, String parentModuleKey) {
        ScannerReport.Component component = this.getReportReader().readComponent(componentRef);
        if (StringUtils.isNotEmpty((String)component.getKey())) {
            this.reportComponents.put(component.getKey(), component);
        } else {
            this.reportComponents.put(parentModuleKey + ":" + component.getPath(), component);
        }
        Iterator iterator = component.getChildRefList().iterator();
        while (iterator.hasNext()) {
            int childId = (Integer)iterator.next();
            this.storeReportComponents(childId, StringUtils.isNotEmpty((String)component.getKey()) ? component.getKey() : parentModuleKey);
        }
    }

    public ScannerReportReader getReportReader() {
        return this.reader;
    }

    private void storeFs(ProjectScanContainer container) {
        InputComponentStore inputFileCache = (InputComponentStore)container.getComponentByType(InputComponentStore.class);
        for (InputFile inputFile : inputFileCache.allFiles()) {
            this.inputFiles.put(((DefaultInputFile)inputFile).getProjectRelativePath(), inputFile);
        }
        for (InputDir inputDir : inputFileCache.allDirs()) {
            this.inputDirs.put(inputDir.relativePath(), inputDir);
        }
    }

    public List<TrackedIssue> trackedIssues() {
        return this.issues;
    }

    public ScannerReport.Component getReportComponent(String key) {
        return this.reportComponents.get(key);
    }

    public List<ScannerReport.Issue> issuesFor(InputComponent inputComponent) {
        int ref = this.reportComponents.get(inputComponent.key()).getRef();
        return this.issuesFor(ref);
    }

    public List<ScannerReport.Issue> issuesFor(ScannerReport.Component reportComponent) {
        int ref = reportComponent.getRef();
        return this.issuesFor(ref);
    }

    private List<ScannerReport.Issue> issuesFor(int ref) {
        ArrayList result = Lists.newArrayList();
        try (CloseableIterator it = this.reader.readComponentIssues(ref);){
            while (it.hasNext()) {
                result.add(it.next());
            }
        }
        return result;
    }

    public Collection<InputFile> inputFiles() {
        return this.inputFiles.values();
    }

    @CheckForNull
    public InputFile inputFile(String relativePath) {
        return this.inputFiles.get(relativePath);
    }

    public Collection<InputDir> inputDirs() {
        return this.inputDirs.values();
    }

    @CheckForNull
    public InputDir inputDir(String relativePath) {
        return this.inputDirs.get(relativePath);
    }

    public Map<String, List<ScannerReport.Measure>> allMeasures() {
        HashMap<String, List<ScannerReport.Measure>> result = new HashMap<String, List<ScannerReport.Measure>>();
        for (Map.Entry<String, ScannerReport.Component> component : this.reportComponents.entrySet()) {
            ArrayList measures = new ArrayList();
            try (CloseableIterator it = this.reader.readComponentMeasures(component.getValue().getRef());){
                Iterators.addAll(measures, (Iterator)it);
            }
            result.put(component.getKey(), measures);
        }
        return result;
    }

    public List<TypeOfText> highlightingTypeFor(InputFile file, int line, int lineOffset) {
        int ref = this.reportComponents.get(file.key()).getRef();
        if (!this.reader.hasSyntaxHighlighting(ref)) {
            return Collections.emptyList();
        }
        TextPointer pointer = file.newPointer(line, lineOffset);
        ArrayList<TypeOfText> result = new ArrayList<TypeOfText>();
        try (CloseableIterator it = this.reader.readComponentSyntaxHighlighting(ref);){
            while (it.hasNext()) {
                ScannerReport.SyntaxHighlightingRule rule = (ScannerReport.SyntaxHighlightingRule)it.next();
                TextRange ruleRange = TaskResult.toRange(file, rule.getRange());
                if (ruleRange.start().compareTo((Object)pointer) > 0 || ruleRange.end().compareTo((Object)pointer) <= 0) continue;
                result.add(ScannerReportUtils.toBatchType(rule.getType()));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read syntax highlighting for " + file, e);
        }
        return result;
    }

    private static TextRange toRange(InputFile file, ScannerReport.TextRange reportRange) {
        return file.newRange(file.newPointer(reportRange.getStartLine(), reportRange.getStartOffset()), file.newPointer(reportRange.getEndLine(), reportRange.getEndOffset()));
    }

    @CheckForNull
    public List<ScannerReport.TextRange> symbolReferencesFor(InputFile file, int symbolStartLine, int symbolStartLineOffset) {
        int ref = this.reportComponents.get(file.key()).getRef();
        try (CloseableIterator symbols = this.getReportReader().readComponentSymbols(ref);){
            while (symbols.hasNext()) {
                ScannerReport.Symbol symbol = (ScannerReport.Symbol)symbols.next();
                if (symbol.getDeclaration().getStartLine() != symbolStartLine || symbol.getDeclaration().getStartOffset() != symbolStartLineOffset) continue;
                List list = symbol.getReferenceList();
                return list;
            }
        }
        return Collections.emptyList();
    }

    public List<ScannerReport.Duplication> duplicationsFor(InputFile file) {
        ArrayList<ScannerReport.Duplication> result = new ArrayList<ScannerReport.Duplication>();
        int ref = this.reportComponents.get(file.key()).getRef();
        try (CloseableIterator it = this.getReportReader().readComponentDuplications(ref);){
            while (it.hasNext()) {
                result.add((ScannerReport.Duplication)it.next());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public List<ScannerReport.CpdTextBlock> duplicationBlocksFor(InputFile file) {
        ArrayList<ScannerReport.CpdTextBlock> result = new ArrayList<ScannerReport.CpdTextBlock>();
        int ref = this.reportComponents.get(file.key()).getRef();
        try (CloseableIterator it = this.getReportReader().readCpdTextBlocks(ref);){
            while (it.hasNext()) {
                result.add((ScannerReport.CpdTextBlock)it.next());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public ScannerReport.LineCoverage coverageFor(InputFile file, int line) {
        int ref = this.reportComponents.get(file.key()).getRef();
        try (CloseableIterator it = this.getReportReader().readComponentCoverage(ref);){
            ScannerReport.LineCoverage coverage;
            do {
                if (!it.hasNext()) return null;
            } while ((coverage = (ScannerReport.LineCoverage)it.next()).getLine() != line);
            ScannerReport.LineCoverage lineCoverage = coverage;
            return lineCoverage;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScannerReport.Test firstTestExecutionForName(InputFile testFile, String testName) {
        int ref = this.reportComponents.get(testFile.key()).getRef();
        try (FileInputStream inputStream = FileUtils.openInputStream((File)this.getReportReader().readTests(ref));){
            ScannerReport.Test test = (ScannerReport.Test)ScannerReport.Test.parser().parseDelimitedFrom((InputStream)inputStream);
            while (test != null) {
                if (test.getName().equals(testName)) {
                    ScannerReport.Test test2 = test;
                    return test2;
                }
                test = (ScannerReport.Test)ScannerReport.Test.parser().parseDelimitedFrom((InputStream)inputStream);
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScannerReport.CoverageDetail coveragePerTestFor(InputFile testFile, String testName) {
        int ref = this.reportComponents.get(testFile.key()).getRef();
        try (FileInputStream inputStream = FileUtils.openInputStream((File)this.getReportReader().readCoverageDetails(ref));){
            ScannerReport.CoverageDetail details = (ScannerReport.CoverageDetail)ScannerReport.CoverageDetail.parser().parseDelimitedFrom((InputStream)inputStream);
            while (details != null) {
                if (details.getTestName().equals(testName)) {
                    ScannerReport.CoverageDetail coverageDetail = details;
                    return coverageDetail;
                }
                details = (ScannerReport.CoverageDetail)ScannerReport.CoverageDetail.parser().parseDelimitedFrom((InputStream)inputStream);
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

