/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.profiling;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.sonar.api.utils.System2;
import org.sonar.scanner.profiling.AbstractTimeProfiling;
import org.sonar.scanner.profiling.ItemProfiling;
import org.sonar.scanner.profiling.Phase;

public class PhaseProfiling
extends AbstractTimeProfiling {
    private final Phase phase;
    private Map<String, ItemProfiling> profilingPerItem = new HashMap<String, ItemProfiling>();

    PhaseProfiling(System2 system, Phase phase) {
        super(system);
        this.phase = phase;
    }

    public static PhaseProfiling create(System2 system, Phase phase) {
        return new PhaseProfiling(system, phase);
    }

    public Phase phase() {
        return this.phase;
    }

    public boolean hasItems() {
        return !this.profilingPerItem.isEmpty();
    }

    public ItemProfiling getProfilingPerItem(Object item) {
        String stringOrSimpleName = PhaseProfiling.toStringOrSimpleName(item);
        return this.profilingPerItem.get(stringOrSimpleName);
    }

    public void newItemProfiling(Object item) {
        String stringOrSimpleName = PhaseProfiling.toStringOrSimpleName(item);
        this.profilingPerItem.put(stringOrSimpleName, new ItemProfiling(this.system(), stringOrSimpleName));
    }

    public void newItemProfiling(String itemName) {
        this.profilingPerItem.put(itemName, new ItemProfiling(this.system(), itemName));
    }

    public void merge(PhaseProfiling other) {
        super.add(other);
        for (Map.Entry<String, ItemProfiling> entry : other.profilingPerItem.entrySet()) {
            if (!this.profilingPerItem.containsKey(entry.getKey())) {
                this.newItemProfiling(entry.getKey());
            }
            this.getProfilingPerItem(entry.getKey()).add(entry.getValue());
        }
    }

    public void dump(Properties props) {
        double percent = (double)this.totalTime() / 100.0;
        for (ItemProfiling itemProfiling : this.profilingPerItem.values()) {
            props.setProperty(itemProfiling.itemName(), Long.toString(itemProfiling.totalTime()));
        }
        for (ItemProfiling itemProfiling : PhaseProfiling.truncate(PhaseProfiling.sortByDescendingTotalTime(this.profilingPerItem).values())) {
            this.println("   o " + itemProfiling.itemName() + ": ", percent, itemProfiling);
        }
    }

    private static String toStringOrSimpleName(Object o) {
        String toString = o.toString();
        if (toString == null || toString.startsWith(o.getClass().getName())) {
            return o.getClass().getSimpleName();
        }
        return toString;
    }
}

