/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.util.stream.Collectors;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.DefaultActiveRule;
import org.sonar.scanner.protocol.Constants;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;

public class ActiveRulesPublisher
implements ReportPublisherStep {
    private final ActiveRules activeRules;

    public ActiveRulesPublisher(ActiveRules activeRules) {
        this.activeRules = activeRules;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        ScannerReport.ActiveRule.Builder builder = ScannerReport.ActiveRule.newBuilder();
        writer.writeActiveRules((Iterable)this.activeRules.findAll().stream().map(DefaultActiveRule.class::cast).map(input -> {
            builder.clear();
            builder.setRuleRepository(input.ruleKey().repository());
            builder.setRuleKey(input.ruleKey().rule());
            builder.setSeverity(Constants.Severity.valueOf((String)input.severity()));
            builder.setCreatedAt(input.createdAt());
            builder.getMutableParamsByKey().putAll(input.params());
            return builder.build();
        }).collect(Collectors.toList()));
    }
}

