/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.AnalysisMode;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.platform.PluginInfo;
import org.sonar.scanner.bootstrap.GlobalConfiguration;
import org.sonar.scanner.bootstrap.ScannerPluginRepository;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.repository.ProjectRepositories;

@ScannerSide
public class AnalysisContextReportPublisher {
    private static final String KEY_VALUE_FORMAT = "  - %s=%s";
    private static final Logger LOG = Loggers.get(AnalysisContextReportPublisher.class);
    private static final String ENV_PROP_PREFIX = "env.";
    private static final String SONAR_PROP_PREFIX = "sonar.";
    private static final int MAX_WIDTH = 1000;
    private final ScannerPluginRepository pluginRepo;
    private final AnalysisMode mode;
    private final System2 system;
    private final ProjectRepositories projectRepos;
    private final GlobalConfiguration globalSettings;
    private final InputModuleHierarchy hierarchy;
    private ScannerReportWriter writer;

    public AnalysisContextReportPublisher(AnalysisMode mode, ScannerPluginRepository pluginRepo, System2 system, ProjectRepositories projectRepos, GlobalConfiguration globalSettings, InputModuleHierarchy hierarchy) {
        this.mode = mode;
        this.pluginRepo = pluginRepo;
        this.system = system;
        this.projectRepos = projectRepos;
        this.globalSettings = globalSettings;
        this.hierarchy = hierarchy;
    }

    public void init(ScannerReportWriter writer) {
        if (this.mode.isIssues()) {
            return;
        }
        this.writer = writer;
        File analysisLog = writer.getFileStructure().analysisLog();
        try (BufferedWriter fileWriter = Files.newBufferedWriter(analysisLog.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            if (LOG.isDebugEnabled()) {
                this.writeEnvVariables(fileWriter);
                this.writeSystemProps(fileWriter);
            }
            this.writePlugins(fileWriter);
            this.writeGlobalSettings(fileWriter);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write analysis log", e);
        }
    }

    private void writePlugins(BufferedWriter fileWriter) throws IOException {
        fileWriter.write("SonarQube plugins:\n");
        for (PluginInfo p : this.pluginRepo.getPluginInfos()) {
            fileWriter.append(String.format("  - %s %s (%s)", p.getName(), p.getVersion(), p.getKey())).append('\n');
        }
    }

    private void writeSystemProps(BufferedWriter fileWriter) throws IOException {
        fileWriter.write("System properties:\n");
        Properties sysProps = this.system.properties();
        for (String prop : new TreeSet<String>(sysProps.stringPropertyNames())) {
            if (prop.startsWith(SONAR_PROP_PREFIX)) continue;
            fileWriter.append(String.format(KEY_VALUE_FORMAT, prop, sysProps.getProperty(prop))).append('\n');
        }
    }

    private void writeEnvVariables(BufferedWriter fileWriter) throws IOException {
        fileWriter.append("Environment variables:\n");
        Map envVariables = this.system.envVariables();
        for (String env : new TreeSet(envVariables.keySet())) {
            fileWriter.append(String.format(KEY_VALUE_FORMAT, env, envVariables.get(env))).append('\n');
        }
    }

    private void writeGlobalSettings(BufferedWriter fileWriter) throws IOException {
        fileWriter.append("Global properties:\n");
        Map<String, String> props = this.globalSettings.getServerSideSettings();
        for (String prop : new TreeSet<String>(props.keySet())) {
            AnalysisContextReportPublisher.dumpPropIfNotSensitive(fileWriter, prop, props.get(prop));
        }
    }

    public void dumpModuleSettings(DefaultInputModule module) {
        if (this.mode.isIssues()) {
            return;
        }
        File analysisLog = this.writer.getFileStructure().analysisLog();
        try (BufferedWriter fileWriter = Files.newBufferedWriter(analysisLog.toPath(), StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
            Map<String, String> moduleSpecificProps = this.collectModuleSpecificProps(module);
            fileWriter.append(String.format("Settings for module: %s", module.key())).append('\n');
            for (String prop : new TreeSet<String>(moduleSpecificProps.keySet())) {
                if (this.isSystemProp(prop) || this.isEnvVariable(prop) || !AnalysisContextReportPublisher.isSqProp(prop)) continue;
                AnalysisContextReportPublisher.dumpPropIfNotSensitive(fileWriter, prop, moduleSpecificProps.get(prop));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write analysis log", e);
        }
    }

    private static void dumpPropIfNotSensitive(BufferedWriter fileWriter, String prop, String value) throws IOException {
        fileWriter.append(String.format(KEY_VALUE_FORMAT, prop, AnalysisContextReportPublisher.sensitive(prop) ? "******" : StringUtils.abbreviate((String)value, (int)1000))).append('\n');
    }

    private Map<String, String> collectModuleSpecificProps(DefaultInputModule module) {
        DefaultInputModule parent;
        HashMap<String, String> moduleSpecificProps = new HashMap<String, String>();
        if (this.projectRepos.moduleExists(module.getKeyWithBranch())) {
            moduleSpecificProps.putAll(this.projectRepos.settings(module.getKeyWithBranch()));
        }
        if ((parent = this.hierarchy.parent((InputModule)module)) == null) {
            moduleSpecificProps.putAll(module.properties());
        } else {
            Map parentProps = parent.properties();
            for (Map.Entry entry : module.properties().entrySet()) {
                if (parentProps.containsKey(entry.getKey()) && ((String)parentProps.get(entry.getKey())).equals(entry.getValue())) continue;
                moduleSpecificProps.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return moduleSpecificProps;
    }

    private static boolean isSqProp(String propKey) {
        return propKey.startsWith(SONAR_PROP_PREFIX);
    }

    private boolean isSystemProp(String propKey) {
        return this.system.properties().containsKey(propKey) && !propKey.startsWith(SONAR_PROP_PREFIX);
    }

    private boolean isEnvVariable(String propKey) {
        return propKey.startsWith(ENV_PROP_PREFIX) && this.system.envVariables().containsKey(propKey.substring(ENV_PROP_PREFIX.length()));
    }

    private static boolean sensitive(String key) {
        return key.equals("sonar.login") || key.contains(".password") || key.contains(".secured");
    }
}

