/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import org.picocontainer.Startable;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.TempFolder;
import org.sonar.api.utils.ZipUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.FileUtils;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.bootstrap.ScannerWsClient;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.AnalysisContextReportPublisher;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.scan.branch.BranchConfiguration;

@ScannerSide
public class ReportPublisher
implements Startable {
    private static final Logger LOG = Loggers.get(ReportPublisher.class);
    public static final String KEEP_REPORT_PROP_KEY = "sonar.scanner.keepReport";
    public static final String VERBOSE_KEY = "sonar.verbose";
    public static final String METADATA_DUMP_FILENAME = "report-task.txt";
    private static final String CHARACTERISTIC = "characteristic";
    private final Configuration settings;
    private final ScannerWsClient wsClient;
    private final AnalysisContextReportPublisher contextPublisher;
    private final InputModuleHierarchy moduleHierarchy;
    private final GlobalAnalysisMode analysisMode;
    private final TempFolder temp;
    private final ReportPublisherStep[] publishers;
    private final Server server;
    private final BranchConfiguration branchConfiguration;
    private Path reportDir;
    private ScannerReportWriter writer;

    public ReportPublisher(Configuration settings, ScannerWsClient wsClient, Server server, AnalysisContextReportPublisher contextPublisher, InputModuleHierarchy moduleHierarchy, GlobalAnalysisMode analysisMode, TempFolder temp, ReportPublisherStep[] publishers, BranchConfiguration branchConfiguration) {
        this.settings = settings;
        this.wsClient = wsClient;
        this.server = server;
        this.contextPublisher = contextPublisher;
        this.moduleHierarchy = moduleHierarchy;
        this.analysisMode = analysisMode;
        this.temp = temp;
        this.publishers = publishers;
        this.branchConfiguration = branchConfiguration;
    }

    public void start() {
        String publicUrl;
        this.reportDir = this.moduleHierarchy.root().getWorkDir().resolve("scanner-report");
        this.writer = new ScannerReportWriter(this.reportDir.toFile());
        this.contextPublisher.init(this.writer);
        if (!this.analysisMode.isIssues() && !this.analysisMode.isMediumTest() && HttpUrl.parse((String)(publicUrl = this.server.getPublicRootUrl())) == null) {
            throw MessageException.of((String)("Failed to parse public URL set in SonarQube server: " + publicUrl));
        }
    }

    public void stop() {
        if (!this.shouldKeepReport()) {
            FileUtils.deleteQuietly((Path)this.reportDir);
        }
    }

    public Path getReportDir() {
        return this.reportDir;
    }

    public ScannerReportWriter getWriter() {
        return this.writer;
    }

    public void execute() {
        String taskId = null;
        if (!this.analysisMode.isIssues()) {
            File report = this.generateReportFile();
            if (this.shouldKeepReport()) {
                LOG.info("Analysis report generated in " + this.reportDir);
            }
            if (!this.analysisMode.isMediumTest()) {
                taskId = this.upload(report);
            }
        }
        this.logSuccess(taskId);
    }

    private boolean shouldKeepReport() {
        return this.settings.getBoolean(KEEP_REPORT_PROP_KEY).orElse(false) != false || this.settings.getBoolean(VERBOSE_KEY).orElse(false) != false;
    }

    private File generateReportFile() {
        try {
            long startTime = System.currentTimeMillis();
            for (ReportPublisherStep publisher : this.publishers) {
                publisher.publish(this.writer);
            }
            long stopTime = System.currentTimeMillis();
            LOG.info("Analysis report generated in {}ms, dir size={}", (Object)(stopTime - startTime), (Object)org.apache.commons.io.FileUtils.byteCountToDisplaySize((long)org.apache.commons.io.FileUtils.sizeOfDirectory((File)this.reportDir.toFile())));
            startTime = System.currentTimeMillis();
            File reportZip = this.temp.newFile("scanner-report", ".zip");
            ZipUtils.zipDir((File)this.reportDir.toFile(), (File)reportZip);
            stopTime = System.currentTimeMillis();
            LOG.info("Analysis reports compressed in {}ms, zip size={}", (Object)(stopTime - startTime), (Object)org.apache.commons.io.FileUtils.byteCountToDisplaySize((long)org.apache.commons.io.FileUtils.sizeOf((File)reportZip)));
            return reportZip;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to prepare analysis report", e);
        }
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    String upload(File report) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    void logSuccess(@Nullable String taskId) {
        if (taskId == null) {
            LOG.info("ANALYSIS SUCCESSFUL");
        } else {
            String publicUrl = this.server.getPublicRootUrl();
            HttpUrl httpUrl = HttpUrl.parse((String)publicUrl);
            LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
            String effectiveKey = this.moduleHierarchy.root().getKeyWithBranch();
            this.settings.get("sonar.organization").ifPresent(org -> metadata.put("organization", (String)org));
            metadata.put("projectKey", effectiveKey);
            metadata.put("serverUrl", publicUrl);
            metadata.put("serverVersion", this.server.getVersion());
            this.settings.get("sonar.branch.name").ifPresent(branch -> metadata.put("branch", (String)branch));
            URL dashboardUrl = httpUrl.newBuilder().addPathSegment("dashboard").addPathSegment("index").addPathSegment(effectiveKey).build().url();
            metadata.put("dashboardUrl", dashboardUrl.toExternalForm());
            URL taskUrl = HttpUrl.parse((String)publicUrl).newBuilder().addPathSegment("api").addPathSegment("ce").addPathSegment("task").addQueryParameter("id", taskId).build().url();
            metadata.put("ceTaskId", taskId);
            metadata.put("ceTaskUrl", taskUrl.toExternalForm());
            LOG.info("ANALYSIS SUCCESSFUL, you can browse {}", (Object)dashboardUrl);
            LOG.info("Note that you will be able to access the updated dashboard once the server has processed the submitted analysis report");
            LOG.info("More about the report processing at {}", (Object)taskUrl);
            this.dumpMetadata(metadata);
        }
    }

    private void dumpMetadata(Map<String, String> metadata) {
        Path file = this.moduleHierarchy.root().getWorkDir().resolve(METADATA_DUMP_FILENAME);
        try (BufferedWriter output = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                output.write(entry.getKey());
                output.write("=");
                output.write(entry.getValue());
                output.write("\n");
            }
            LOG.debug("Report metadata written to {}", (Object)file);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to dump " + file, e);
        }
    }
}

