/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import java.util.List;
import javax.annotation.CheckForNull;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.bootstrap.ProjectKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.analysis.AnalysisProperties;
import org.sonar.scanner.repository.ProjectRepositories;
import org.sonar.scanner.repository.QualityProfileLoader;
import org.sonar.scanner.rule.ModuleQProfiles;
import org.sonarqube.ws.QualityProfiles;

public class QualityProfileProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(QualityProfileProvider.class);
    private static final String LOG_MSG = "Load quality profiles";
    private ModuleQProfiles profiles = null;

    public ModuleQProfiles provide(ProjectKey projectKey, QualityProfileLoader loader, ProjectRepositories projectRepositories, AnalysisProperties props) {
        if (this.profiles == null) {
            Profiler profiler = Profiler.create((Logger)LOG).startInfo(LOG_MSG);
            List<QualityProfiles.SearchWsResponse.QualityProfile> profileList = !projectRepositories.exists() ? loader.loadDefault(QualityProfileProvider.getSonarProfile(props)) : loader.load(projectKey.get(), QualityProfileProvider.getSonarProfile(props));
            profiler.stopInfo();
            this.profiles = new ModuleQProfiles(profileList);
        }
        return this.profiles;
    }

    @CheckForNull
    private static String getSonarProfile(AnalysisProperties props) {
        String profile = null;
        if (props.properties().containsKey("sonar.profile")) {
            profile = props.property("sonar.profile");
            LOG.warn("Ability to set quality profile from command line using 'sonar.profile' is deprecated and will be dropped in a future SonarQube version. Please configure quality profile used by your project on SonarQube server.");
        }
        return profile;
    }
}

