/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository.settings;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.ScannerWsClient;
import org.sonar.scanner.repository.settings.SettingsLoader;
import org.sonar.scanner.util.ScannerUtils;
import org.sonarqube.ws.Settings;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.WsRequest;

public class DefaultSettingsLoader
implements SettingsLoader {
    private ScannerWsClient wsClient;
    private static final Logger LOG = Loggers.get(DefaultSettingsLoader.class);

    public DefaultSettingsLoader(ScannerWsClient wsClient) {
        this.wsClient = wsClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> load(@Nullable String componentKey) {
        String url = "api/settings/values.protobuf";
        Profiler profiler = Profiler.create((Logger)LOG);
        if (componentKey != null) {
            url = url + "?component=" + ScannerUtils.encodeForUrl(componentKey);
            profiler.startInfo("Load settings for component '" + componentKey + "'");
        } else {
            profiler.startInfo("Load global settings");
        }
        try (InputStream is = this.wsClient.call((WsRequest)new GetRequest(url)).contentStream();){
            Settings.ValuesWsResponse values = Settings.ValuesWsResponse.parseFrom((InputStream)is);
            profiler.stopInfo();
            Map<String, String> map = DefaultSettingsLoader.toMap(values.getSettingsList());
            return map;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load server settings", e);
        }
    }

    @VisibleForTesting
    static Map<String, String> toMap(List<Settings.Setting> settingsList) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        block5: for (Settings.Setting s : settingsList) {
            if (s.getInherited()) continue;
            switch (s.getValueOneOfCase()) {
                case VALUE: {
                    result.put(s.getKey(), s.getValue());
                    continue block5;
                }
                case VALUES: {
                    result.put(s.getKey(), s.getValues().getValuesList().stream().map(StringEscapeUtils::escapeCsv).collect(Collectors.joining(",")));
                    continue block5;
                }
                case FIELDVALUES: {
                    DefaultSettingsLoader.convertPropertySetToProps(result, s);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknow property value for " + s.getKey());
        }
        return result;
    }

    private static void convertPropertySetToProps(Map<String, String> result, Settings.Setting s) {
        ArrayList<String> ids = new ArrayList<String>();
        int id = 1;
        for (Settings.FieldValues.Value v : s.getFieldValues().getFieldValuesList()) {
            for (Map.Entry entry : v.getValue().entrySet()) {
                result.put(s.getKey() + "." + id + "." + (String)entry.getKey(), (String)entry.getValue());
            }
            ids.add(String.valueOf(id));
            ++id;
        }
        result.put(s.getKey(), ids.stream().collect(Collectors.joining(",")));
    }
}

