/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.rule.ModuleQProfiles;
import org.sonar.scanner.rule.QProfile;

@ScannerSide
public class QProfileVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(QProfileVerifier.class);
    private final Configuration settings;
    private final FileSystem fs;
    private final ModuleQProfiles profiles;

    public QProfileVerifier(Configuration settings, FileSystem fs, ModuleQProfiles profiles) {
        this.settings = settings;
        this.fs = fs;
        this.profiles = profiles;
    }

    public void execute() {
        this.execute(LOG);
    }

    @VisibleForTesting
    void execute(Logger logger) {
        String defaultName = this.settings.get("sonar.profile").orElse(null);
        boolean defaultNameUsed = StringUtils.isBlank((String)defaultName);
        for (String lang : this.fs.languages()) {
            QProfile profile = this.profiles.findByLanguage(lang);
            if (profile == null) {
                logger.warn("No Quality profile found for language {}", (Object)lang);
                continue;
            }
            logger.info("Quality profile for {}: {}", (Object)lang, (Object)profile.getName());
            if (!StringUtils.isNotEmpty((String)defaultName) || !defaultName.equals(profile.getName())) continue;
            defaultNameUsed = true;
        }
        if (!defaultNameUsed && !this.fs.languages().isEmpty()) {
            throw MessageException.of((String)("sonar.profile was set to '" + defaultName + "' but didn't match any profile for any language. Please check your configuration."));
        }
    }
}

