/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RuleQuery;

@Immutable
public class RuleFinderCompatibility
implements RuleFinder {
    private final Rules rules;

    public RuleFinderCompatibility(Rules rules) {
        this.rules = rules;
    }

    public org.sonar.api.rules.Rule findById(int ruleId) {
        throw new UnsupportedOperationException("Unable to find rule by id");
    }

    public org.sonar.api.rules.Rule findByKey(String repositoryKey, String key) {
        return this.findByKey(RuleKey.of((String)repositoryKey, (String)key));
    }

    public org.sonar.api.rules.Rule findByKey(RuleKey key) {
        return RuleFinderCompatibility.toRule(this.rules.find(key));
    }

    public org.sonar.api.rules.Rule find(RuleQuery query) {
        Collection<org.sonar.api.rules.Rule> all = this.findAll(query);
        if (all.size() > 1) {
            throw new IllegalArgumentException("Non unique result for rule query: " + ReflectionToStringBuilder.toString((Object)query, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
        }
        if (all.isEmpty()) {
            return null;
        }
        return all.iterator().next();
    }

    public Collection<org.sonar.api.rules.Rule> findAll(RuleQuery query) {
        if (query.getConfigKey() != null) {
            if (query.getRepositoryKey() != null && query.getKey() == null) {
                return this.byInternalKey(query);
            }
        } else if (query.getRepositoryKey() != null) {
            if (query.getKey() != null) {
                return this.byKey(query);
            }
            return this.byRepository(query);
        }
        throw new UnsupportedOperationException("Unable to find rule by query");
    }

    private Collection<org.sonar.api.rules.Rule> byRepository(RuleQuery query) {
        return this.rules.findByRepository(query.getRepositoryKey()).stream().map(RuleFinderCompatibility::toRule).collect(Collectors.toList());
    }

    private Collection<org.sonar.api.rules.Rule> byKey(RuleQuery query) {
        org.sonar.api.rules.Rule rule = RuleFinderCompatibility.toRule(this.rules.find(RuleKey.of((String)query.getRepositoryKey(), (String)query.getKey())));
        return rule != null ? Arrays.asList(rule) : Collections.emptyList();
    }

    private Collection<org.sonar.api.rules.Rule> byInternalKey(RuleQuery query) {
        return this.rules.findByInternalKey(query.getRepositoryKey(), query.getConfigKey()).stream().map(RuleFinderCompatibility::toRule).collect(Collectors.toList());
    }

    @CheckForNull
    private static org.sonar.api.rules.Rule toRule(@Nullable Rule ar) {
        return ar == null ? null : org.sonar.api.rules.Rule.create((String)ar.key().repository(), (String)ar.key().rule()).setName(ar.name()).setConfigKey(ar.internalKey());
    }
}

