/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.util.HashMap;
import java.util.Map;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.scanner.scan.DefaultInputModuleHierarchy;
import org.sonar.scanner.scan.ProjectBuildersExecutor;
import org.sonar.scanner.scan.ProjectReactorValidator;
import org.sonar.scanner.scan.filesystem.BatchIdGenerator;

public class InputModuleHierarchyProvider
extends ProviderAdapter {
    private DefaultInputModuleHierarchy hierarchy = null;

    public DefaultInputModuleHierarchy provide(ProjectBuildersExecutor projectBuildersExecutor, ProjectReactorValidator validator, ProjectReactor projectReactor, BatchIdGenerator batchIdGenerator) {
        if (this.hierarchy == null) {
            projectBuildersExecutor.execute(projectReactor);
            validator.validate(projectReactor);
            DefaultInputModule root = new DefaultInputModule(projectReactor.getRoot(), batchIdGenerator.getAsInt());
            Map<DefaultInputModule, DefaultInputModule> parents = InputModuleHierarchyProvider.createChildren(root, batchIdGenerator, new HashMap<DefaultInputModule, DefaultInputModule>());
            this.hierarchy = parents.isEmpty() ? new DefaultInputModuleHierarchy(root) : new DefaultInputModuleHierarchy(parents);
        }
        return this.hierarchy;
    }

    private static Map<DefaultInputModule, DefaultInputModule> createChildren(DefaultInputModule parent, BatchIdGenerator batchIdGenerator, Map<DefaultInputModule, DefaultInputModule> parents) {
        for (ProjectDefinition def : parent.definition().getSubProjects()) {
            DefaultInputModule child = new DefaultInputModule(def, batchIdGenerator.getAsInt());
            parents.put(child, parent);
            InputModuleHierarchyProvider.createChildren(child, batchIdGenerator, parents);
        }
        return parents;
    }
}

