/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.metric.ScannerMetrics;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.scanner.ProjectAnalysisInfo;
import org.sonar.scanner.analysis.AnalysisProperties;
import org.sonar.scanner.analysis.AnalysisTempFolderProvider;
import org.sonar.scanner.analysis.DefaultAnalysisMode;
import org.sonar.scanner.bootstrap.ExtensionInstaller;
import org.sonar.scanner.bootstrap.ExtensionMatcher;
import org.sonar.scanner.bootstrap.ExtensionUtils;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.bootstrap.MetricProvider;
import org.sonar.scanner.cpd.CpdExecutor;
import org.sonar.scanner.cpd.CpdSettings;
import org.sonar.scanner.cpd.index.SonarCpdBlockIndex;
import org.sonar.scanner.deprecated.test.TestPlanBuilder;
import org.sonar.scanner.deprecated.test.TestableBuilder;
import org.sonar.scanner.events.EventBus;
import org.sonar.scanner.index.DefaultIndex;
import org.sonar.scanner.issue.DefaultProjectIssues;
import org.sonar.scanner.issue.IssueCache;
import org.sonar.scanner.issue.tracking.DefaultServerLineHashesLoader;
import org.sonar.scanner.issue.tracking.IssueTransition;
import org.sonar.scanner.issue.tracking.LocalIssueTracking;
import org.sonar.scanner.issue.tracking.ServerIssueRepository;
import org.sonar.scanner.issue.tracking.ServerLineHashesLoader;
import org.sonar.scanner.mediumtest.ScanTaskObservers;
import org.sonar.scanner.phases.PhasesTimeProfiler;
import org.sonar.scanner.profiling.PhasesSumUpTimeProfiler;
import org.sonar.scanner.report.ActiveRulesPublisher;
import org.sonar.scanner.report.AnalysisContextReportPublisher;
import org.sonar.scanner.report.ComponentsPublisher;
import org.sonar.scanner.report.ContextPropertiesPublisher;
import org.sonar.scanner.report.CoveragePublisher;
import org.sonar.scanner.report.MeasuresPublisher;
import org.sonar.scanner.report.MetadataPublisher;
import org.sonar.scanner.report.ReportPublisher;
import org.sonar.scanner.report.SourcePublisher;
import org.sonar.scanner.report.TestExecutionAndCoveragePublisher;
import org.sonar.scanner.repository.ContextPropertiesCache;
import org.sonar.scanner.repository.DefaultProjectRepositoriesLoader;
import org.sonar.scanner.repository.DefaultQualityProfileLoader;
import org.sonar.scanner.repository.DefaultServerIssuesLoader;
import org.sonar.scanner.repository.ProjectRepositories;
import org.sonar.scanner.repository.ProjectRepositoriesLoader;
import org.sonar.scanner.repository.ProjectRepositoriesProvider;
import org.sonar.scanner.repository.QualityProfileLoader;
import org.sonar.scanner.repository.QualityProfileProvider;
import org.sonar.scanner.repository.ServerIssuesLoader;
import org.sonar.scanner.repository.language.DefaultLanguagesRepository;
import org.sonar.scanner.rule.ActiveRulesLoader;
import org.sonar.scanner.rule.ActiveRulesProvider;
import org.sonar.scanner.rule.DefaultActiveRulesLoader;
import org.sonar.scanner.rule.DefaultRulesLoader;
import org.sonar.scanner.rule.RulesLoader;
import org.sonar.scanner.rule.RulesProvider;
import org.sonar.scanner.scan.DefaultComponentTree;
import org.sonar.scanner.scan.InputModuleHierarchyProvider;
import org.sonar.scanner.scan.ModuleIndexer;
import org.sonar.scanner.scan.ModuleScanContainer;
import org.sonar.scanner.scan.MutableProjectReactorProvider;
import org.sonar.scanner.scan.MutableProjectSettings;
import org.sonar.scanner.scan.ProjectBuildersExecutor;
import org.sonar.scanner.scan.ProjectLock;
import org.sonar.scanner.scan.ProjectReactorBuilder;
import org.sonar.scanner.scan.ProjectReactorValidator;
import org.sonar.scanner.scan.ProjectSettingsProvider;
import org.sonar.scanner.scan.WorkDirectoriesInitializer;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.branch.BranchConfigurationProvider;
import org.sonar.scanner.scan.branch.BranchType;
import org.sonar.scanner.scan.branch.ProjectBranchesProvider;
import org.sonar.scanner.scan.filesystem.BatchIdGenerator;
import org.sonar.scanner.scan.filesystem.InputComponentStoreProvider;
import org.sonar.scanner.scan.filesystem.StatusDetection;
import org.sonar.scanner.scan.measure.DefaultMetricFinder;
import org.sonar.scanner.scan.measure.DeprecatedMetricFinder;
import org.sonar.scanner.scan.measure.MeasureCache;
import org.sonar.scanner.scm.ScmChangedFilesProvider;
import org.sonar.scanner.storage.Storages;

public class ProjectScanContainer
extends ComponentContainer {
    private static final Logger LOG = Loggers.get(ProjectScanContainer.class);
    private final AnalysisProperties props;

    public ProjectScanContainer(ComponentContainer globalContainer, AnalysisProperties props) {
        super(globalContainer);
        this.props = props;
    }

    protected void doBeforeStart() {
        this.addBatchComponents();
        this.addBatchExtensions();
        ProjectLock lock = (ProjectLock)this.getComponentByType(ProjectLock.class);
        lock.tryLock();
        ((WorkDirectoriesInitializer)this.getComponentByType(WorkDirectoriesInitializer.class)).execute();
        Settings settings = (Settings)this.getComponentByType(Settings.class);
        if (settings != null && settings.getBoolean("sonar.showProfiling")) {
            this.add(new Object[]{PhasesSumUpTimeProfiler.class});
        }
        if (this.isTherePreviousAnalysis()) {
            this.addIssueTrackingComponents();
        }
    }

    private void addBatchComponents() {
        this.add(new Object[]{this.props, ProjectReactorBuilder.class, WorkDirectoriesInitializer.class, new MutableProjectReactorProvider(), ProjectBuildersExecutor.class, ProjectLock.class, EventBus.class, PhasesTimeProfiler.class, ResourceTypes.class, ProjectReactorValidator.class, MetricProvider.class, ProjectAnalysisInfo.class, DefaultIndex.class, Storages.class, new RulesProvider(), new BranchConfigurationProvider(), new ProjectBranchesProvider(), DefaultAnalysisMode.class, new ProjectRepositoriesProvider(), new AnalysisTempFolderProvider(), ModuleIndexer.class, new InputComponentStoreProvider(), PathResolver.class, new InputModuleHierarchyProvider(), DefaultComponentTree.class, BatchIdGenerator.class, new ScmChangedFilesProvider(), StatusDetection.class, new ActiveRulesProvider(), new QualityProfileProvider(), IssueCache.class, DefaultProjectIssues.class, IssueTransition.class, DefaultMetricFinder.class, DeprecatedMetricFinder.class, TestPlanBuilder.class, TestableBuilder.class, Languages.class, DefaultLanguagesRepository.class, MeasureCache.class, ContextPropertiesCache.class, ContextPropertiesPublisher.class, SensorStrategy.class, MutableProjectSettings.class, new ProjectSettingsProvider(), ScannerMetrics.class, ReportPublisher.class, AnalysisContextReportPublisher.class, MetadataPublisher.class, ActiveRulesPublisher.class, ComponentsPublisher.class, MeasuresPublisher.class, CoveragePublisher.class, SourcePublisher.class, TestExecutionAndCoveragePublisher.class, CpdExecutor.class, CpdSettings.class, SonarCpdBlockIndex.class, ScanTaskObservers.class});
        this.addIfMissing(DefaultRulesLoader.class, RulesLoader.class);
        this.addIfMissing(DefaultActiveRulesLoader.class, ActiveRulesLoader.class);
        this.addIfMissing(DefaultQualityProfileLoader.class, QualityProfileLoader.class);
        this.addIfMissing(DefaultProjectRepositoriesLoader.class, ProjectRepositoriesLoader.class);
    }

    private void addIssueTrackingComponents() {
        this.add(new Object[]{LocalIssueTracking.class, ServerIssueRepository.class});
        this.addIfMissing(DefaultServerIssuesLoader.class, ServerIssuesLoader.class);
        this.addIfMissing(DefaultServerLineHashesLoader.class, ServerLineHashesLoader.class);
    }

    private boolean isTherePreviousAnalysis() {
        return ((ProjectRepositories)this.getComponentByType(ProjectRepositories.class)).lastAnalysisDate() != null;
    }

    private void addBatchExtensions() {
        ((ExtensionInstaller)this.getComponentByType(ExtensionInstaller.class)).install(this, new BatchExtensionFilter());
    }

    protected void doAfterStart() {
        String branchName;
        String branch;
        GlobalAnalysisMode analysisMode = (GlobalAnalysisMode)this.getComponentByType(GlobalAnalysisMode.class);
        InputModuleHierarchy tree = (InputModuleHierarchy)this.getComponentByType(InputModuleHierarchy.class);
        LOG.info("Project key: {}", (Object)tree.root().key());
        String organization = this.props.property("sonar.organization");
        if (StringUtils.isNotEmpty((String)organization)) {
            LOG.info("Organization key: {}", (Object)organization);
        }
        if ((branch = tree.root().definition().getBranch()) != null) {
            LOG.info("Branch key: {}", (Object)branch);
            LOG.warn("The use of \"sonar.branch\" is deprecated and replaced by \"{}\". See {}.", (Object)"sonar.branch.name", (Object)"https://redirect.sonarsource.com/doc/branches.html");
        }
        if ((branchName = this.props.property("sonar.branch.name")) != null) {
            BranchConfiguration branchConfig = (BranchConfiguration)this.getComponentByType(BranchConfiguration.class);
            LOG.info("Branch name: {}, type: {}", (Object)branchName, (Object)ProjectScanContainer.toDisplayName(branchConfig.branchType()));
        }
        LOG.debug("Start recursive analysis of project modules");
        this.scanRecursively(tree, tree.root(), analysisMode);
        if (analysisMode.isMediumTest()) {
            ((ScanTaskObservers)this.getComponentByType(ScanTaskObservers.class)).notifyEndOfScanTask();
        }
    }

    private static String toDisplayName(BranchType branchType) {
        switch (branchType) {
            case LONG: {
                return "long living";
            }
            case SHORT: {
                return "short living";
            }
        }
        throw new UnsupportedOperationException("unknown branch type: " + (Object)((Object)branchType));
    }

    private void scanRecursively(InputModuleHierarchy tree, DefaultInputModule module, GlobalAnalysisMode analysisMode) {
        for (DefaultInputModule child : tree.children((InputModule)module)) {
            this.scanRecursively(tree, child, analysisMode);
        }
        this.scan(module, analysisMode);
    }

    @VisibleForTesting
    void scan(DefaultInputModule module, GlobalAnalysisMode analysisMode) {
        new ModuleScanContainer(this, module, analysisMode).execute();
    }

    static class BatchExtensionFilter
    implements ExtensionMatcher {
        BatchExtensionFilter() {
        }

        @Override
        public boolean accept(Object extension) {
            return ExtensionUtils.isScannerSide(extension) && ExtensionUtils.isInstantiationStrategy(extension, "PER_BATCH");
        }
    }
}

