/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.core.util.FileUtils;

public class WorkDirectoriesInitializer {
    private InputModuleHierarchy moduleHierarchy;

    public WorkDirectoriesInitializer(InputModuleHierarchy moduleHierarchy) {
        this.moduleHierarchy = moduleHierarchy;
    }

    public void execute() {
        this.cleanAllWorkingDirs(this.moduleHierarchy.root());
        this.mkdirsAllWorkingDirs(this.moduleHierarchy.root());
    }

    private void cleanAllWorkingDirs(DefaultInputModule module) {
        for (DefaultInputModule sub : this.moduleHierarchy.children((InputModule)module)) {
            this.cleanAllWorkingDirs(sub);
        }
        if (Files.exists(module.getWorkDir(), new LinkOption[0])) {
            WorkDirectoriesInitializer.deleteAllRecursivelyExceptLockFile(module.getWorkDir());
        }
    }

    private void mkdirsAllWorkingDirs(DefaultInputModule module) {
        for (DefaultInputModule sub : this.moduleHierarchy.children((InputModule)module)) {
            this.mkdirsAllWorkingDirs(sub);
        }
        try {
            Files.createDirectories(module.getWorkDir(), new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to create working dir: " + module.getWorkDir(), e);
        }
    }

    private static void deleteAllRecursivelyExceptLockFile(Path dirToDelete) {
        try (DirectoryStream<Path> stream = WorkDirectoriesInitializer.list(dirToDelete);){
            Iterator<Path> it = stream.iterator();
            while (it.hasNext()) {
                FileUtils.deleteQuietly((File)it.next().toFile());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to clean working directory: " + dirToDelete.toString(), e);
        }
    }

    private static DirectoryStream<Path> list(Path dir) throws IOException {
        return Files.newDirectoryStream(dir, entry -> !".sonar_lock".equals(entry.getFileName().toString()));
    }
}

