/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.util.SortedSet;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.scanner.scan.filesystem.InputComponentStore;

@ScannerSide
public class ModuleInputComponentStore
extends DefaultFileSystem.Cache {
    private final String moduleKey;
    private final InputComponentStore inputComponentStore;
    private final SensorStrategy strategy;

    public ModuleInputComponentStore(InputModule module, InputComponentStore inputComponentStore, SensorStrategy strategy) {
        this.moduleKey = module.key();
        this.inputComponentStore = inputComponentStore;
        this.strategy = strategy;
    }

    public Iterable<InputFile> inputFiles() {
        if (this.strategy.isGlobal()) {
            return this.inputComponentStore.allFiles();
        }
        return this.inputComponentStore.filesByModule(this.moduleKey);
    }

    public InputFile inputFile(String relativePath) {
        if (this.strategy.isGlobal()) {
            return this.inputComponentStore.getFile(relativePath);
        }
        return this.inputComponentStore.getFile(this.moduleKey, relativePath);
    }

    public InputDir inputDir(String relativePath) {
        if (this.strategy.isGlobal()) {
            return this.inputComponentStore.getDir(relativePath);
        }
        return this.inputComponentStore.getDir(this.moduleKey, relativePath);
    }

    public SortedSet<String> languages() {
        if (this.strategy.isGlobal()) {
            return this.inputComponentStore.getLanguages();
        }
        return this.inputComponentStore.getLanguages(this.moduleKey);
    }

    protected void doAdd(InputFile inputFile) {
        this.inputComponentStore.put(inputFile);
    }

    protected void doAdd(InputDir inputDir) {
        this.inputComponentStore.put(inputDir);
    }

    public Iterable<InputFile> getFilesByName(String filename) {
        return this.inputComponentStore.getFilesByName(filename);
    }

    public Iterable<InputFile> getFilesByExtension(String extension) {
        return this.inputComponentStore.getFilesByExtension(extension);
    }
}

