/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.storage;

import com.persistit.Persistit;
import com.persistit.exception.PersistitException;
import com.persistit.logging.PersistitLogger;
import com.persistit.logging.Slf4jAdapter;
import java.io.File;
import java.util.Properties;
import org.picocontainer.Startable;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.utils.TempFolder;
import org.sonar.core.util.FileUtils;

@ScannerSide
public class StoragesManager
implements Startable {
    private File tempDir;
    private Persistit persistit;
    private final TempFolder tempFolder;

    public StoragesManager(TempFolder tempFolder) {
        this.tempFolder = tempFolder;
        this.initPersistit();
    }

    private void initPersistit() {
        try {
            this.tempDir = this.tempFolder.newDir("caches");
            this.persistit = new Persistit();
            this.persistit.setPersistitLogger((PersistitLogger)new Slf4jAdapter(LoggerFactory.getLogger((String)"PERSISTIT")));
            Properties props = new Properties();
            props.setProperty("datapath", this.tempDir.getAbsolutePath());
            props.setProperty("logpath", "${datapath}/log");
            props.setProperty("logfile", "${logpath}/persistit_${timestamp}.log");
            props.setProperty("buffer.count.8192", "10");
            props.setProperty("journalpath", "${datapath}/journal");
            props.setProperty("tmpvoldir", "${datapath}");
            props.setProperty("volume.1", "${datapath}/persistit,create,pageSize:8192,initialPages:10,extensionPages:100,maximumPages:25000");
            props.setProperty("jmx", "false");
            this.persistit.setProperties(props);
            this.persistit.initialize();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to start caches", e);
        }
    }

    public void start() {
    }

    public void stop() {
        if (this.persistit != null) {
            try {
                this.persistit.close(false);
                this.persistit = null;
            }
            catch (PersistitException e) {
                throw new IllegalStateException("Fail to close caches", e);
            }
        }
        FileUtils.deleteQuietly((File)this.tempDir);
        this.tempDir = null;
    }

    File tempDir() {
        return this.tempDir;
    }

    Persistit persistit() {
        return this.persistit;
    }
}

