/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.protocol.viewer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.annotation.CheckForNull;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonar.core.util.CloseableIterator;
import org.sonar.scanner.protocol.output.FileStructure;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportReader;
import org.sonar.scanner.protocol.viewer.TextLineNumber;

public class ScannerReportViewerApp {
    private JFrame frame;
    private ScannerReportReader reader;
    private ScannerReport.Metadata metadata;
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private JTree componentTree;
    private JSplitPane splitPane;
    private JTabbedPane tabbedPane;
    private JScrollPane treeScrollPane;
    private JScrollPane componentDetailsTab;
    private JScrollPane highlightingTab;
    private JScrollPane symbolTab;
    private JEditorPane componentEditor;
    private JEditorPane highlightingEditor;
    private JEditorPane symbolEditor;
    private JScrollPane sourceTab;
    private JEditorPane sourceEditor;
    private JScrollPane coverageTab;
    private JEditorPane coverageEditor;
    private JScrollPane testsTab;
    private JEditorPane testsEditor;
    private TextLineNumber textLineNumber;
    private JScrollPane duplicationTab;
    private JEditorPane duplicationEditor;
    private JScrollPane issuesTab;
    private JEditorPane issuesEditor;
    private JScrollPane externalIssuesTab;
    private JEditorPane externalIssuesEditor;
    private JScrollPane measuresTab;
    private JEditorPane measuresEditor;
    private JScrollPane scmTab;
    private JEditorPane scmEditor;
    private JScrollPane activeRuleTab;
    private JEditorPane activeRuleEditor;
    private JScrollPane adHocRuleTab;
    private JEditorPane adHocRuleEditor;
    private JScrollPane qualityProfileTab;
    private JEditorPane qualityProfileEditor;
    private JScrollPane pluginTab;
    private JEditorPane pluginEditor;
    private JScrollPane cpdTextBlocksTab;
    private JEditorPane cpdTextBlocksEditor;
    private JScrollPane significantCodeTab;
    private JEditorPane significantCodeEditor;
    private JScrollPane metadataTab;
    private JEditorPane metadataEditor;

    public ScannerReportViewerApp() {
        this.initialize();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> {
            try {
                ScannerReportViewerApp window = new ScannerReportViewerApp();
                window.frame.setVisible(true);
                window.loadReport();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void loadReport() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Choose scanner report directory");
        File lastReport = this.getLastUsedReport();
        if (lastReport != null) {
            fc.setCurrentDirectory(lastReport);
        }
        fc.setFileSelectionMode(1);
        fc.setFileHidingEnabled(false);
        fc.setApproveButtonText("Open scanner report");
        int returnVal = fc.showOpenDialog(this.frame);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                this.setLastUsedReport(file);
                this.loadReport(file);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Error", 0);
                this.exit();
            }
        } else {
            this.exit();
        }
    }

    @CheckForNull
    private File getLastUsedReport() {
        File f = new File(System.getProperty("java.io.tmpdir"), ".last_batch_report_dir");
        if (f.exists()) {
            String path;
            try {
                path = FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                return null;
            }
            File lastReport = new File(path);
            if (lastReport.exists() && lastReport.isDirectory()) {
                return lastReport;
            }
        }
        return null;
    }

    private void setLastUsedReport(File lastReport) throws IOException {
        File f = new File(System.getProperty("java.io.tmpdir"), ".last_batch_report_dir");
        String fullPath = lastReport.getAbsolutePath();
        FileUtils.write((File)f, (CharSequence)fullPath, (Charset)StandardCharsets.UTF_8);
    }

    private void exit() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    private void loadReport(File file) {
        FileStructure fileStructure = new FileStructure(file);
        this.reader = new ScannerReportReader(fileStructure);
        this.metadata = this.reader.readMetadata();
        this.updateTitle();
        this.loadComponents();
        this.updateActiveRules();
        this.updateAdHocRules();
        this.updateQualityProfiles();
        this.updatePlugins();
        this.updateMetadata();
    }

    private void loadComponents() {
        int rootComponentRef = this.metadata.getRootComponentRef();
        ScannerReport.Component component = this.reader.readComponent(rootComponentRef);
        DefaultMutableTreeNode project = ScannerReportViewerApp.createNode(component);
        this.loadChildren(component, project);
        this.getComponentTree().setModel(new DefaultTreeModel(project));
    }

    private static DefaultMutableTreeNode createNode(ScannerReport.Component component) {
        return new DefaultMutableTreeNode(component){

            @Override
            public String toString() {
                return ScannerReportViewerApp.getNodeName((ScannerReport.Component)this.getUserObject());
            }
        };
    }

    private static String getNodeName(ScannerReport.Component component) {
        switch (component.getType()) {
            case PROJECT: 
            case MODULE: {
                return component.getName();
            }
            case DIRECTORY: 
            case FILE: {
                return component.getProjectRelativePath();
            }
        }
        throw new IllegalArgumentException("Unknow component type: " + component.getType());
    }

    private void loadChildren(ScannerReport.Component parentComponent, DefaultMutableTreeNode parentNode) {
        for (int ref : parentComponent.getChildRefList()) {
            ScannerReport.Component child = this.reader.readComponent(ref);
            DefaultMutableTreeNode childNode = ScannerReportViewerApp.createNode(child);
            parentNode.add(childNode);
            this.loadChildren(child, childNode);
        }
    }

    private void updateTitle() {
        this.frame.setTitle(this.metadata.getProjectKey() + (String)(StringUtils.isNotEmpty((CharSequence)this.metadata.getBranchName()) ? " (" + this.metadata.getBranchName() + ")" : "") + " " + this.sdf.format(new Date(this.metadata.getAnalysisDate())));
    }

    private void updateDetails(ScannerReport.Component component) {
        this.componentEditor.setText(component.toString());
        this.updateHighlighting(component);
        this.updateSymbols(component);
        this.updateSource(component);
        this.updateCoverage(component);
        this.updateDuplications(component);
        this.updateIssues(component);
        this.updateExternalIssues(component);
        this.updateMeasures(component);
        this.updateScm(component);
        this.updateCpdTextBlocks(component);
        this.updateSignificantCode(component);
    }

    private void updateCpdTextBlocks(ScannerReport.Component component) {
        this.cpdTextBlocksEditor.setText("");
        if (this.reader.hasCoverage(component.getRef())) {
            try (CloseableIterator<ScannerReport.CpdTextBlock> it = this.reader.readCpdTextBlocks(component.getRef());){
                while (it.hasNext()) {
                    ScannerReport.CpdTextBlock textBlock = (ScannerReport.CpdTextBlock)it.next();
                    this.cpdTextBlocksEditor.getDocument().insertString(this.cpdTextBlocksEditor.getDocument().getLength(), textBlock + "\n", null);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't read CPD text blocks for " + ScannerReportViewerApp.getNodeName(component), e);
            }
        }
    }

    private void updateSignificantCode(ScannerReport.Component component) {
        this.significantCodeEditor.setText("");
        if (this.reader.hasCoverage(component.getRef())) {
            try (CloseableIterator<ScannerReport.LineSgnificantCode> it = this.reader.readComponentSignificantCode(component.getRef());){
                if (it != null) {
                    while (it.hasNext()) {
                        ScannerReport.LineSgnificantCode textBlock = (ScannerReport.LineSgnificantCode)it.next();
                        this.significantCodeEditor.getDocument().insertString(this.significantCodeEditor.getDocument().getLength(), textBlock + "\n", null);
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't read significant code for " + ScannerReportViewerApp.getNodeName(component), e);
            }
        }
    }

    private void updateDuplications(ScannerReport.Component component) {
        this.duplicationEditor.setText("");
        if (this.reader.hasCoverage(component.getRef())) {
            try (CloseableIterator<ScannerReport.Duplication> it = this.reader.readComponentDuplications(component.getRef());){
                while (it.hasNext()) {
                    ScannerReport.Duplication dup = (ScannerReport.Duplication)it.next();
                    this.duplicationEditor.getDocument().insertString(this.duplicationEditor.getDocument().getLength(), dup + "\n", null);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't read duplications for " + ScannerReportViewerApp.getNodeName(component), e);
            }
        }
    }

    private void updateIssues(ScannerReport.Component component) {
        this.issuesEditor.setText("");
        try (CloseableIterator<ScannerReport.Issue> it = this.reader.readComponentIssues(component.getRef());){
            while (it.hasNext()) {
                ScannerReport.Issue issue = (ScannerReport.Issue)it.next();
                int offset = this.issuesEditor.getDocument().getLength();
                this.issuesEditor.getDocument().insertString(offset, issue.toString(), null);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read issues for " + ScannerReportViewerApp.getNodeName(component), e);
        }
    }

    private void updateExternalIssues(ScannerReport.Component component) {
        this.externalIssuesEditor.setText("");
        try (CloseableIterator<ScannerReport.ExternalIssue> it = this.reader.readComponentExternalIssues(component.getRef());){
            while (it.hasNext()) {
                ScannerReport.ExternalIssue issue = (ScannerReport.ExternalIssue)it.next();
                int offset = this.externalIssuesEditor.getDocument().getLength();
                this.externalIssuesEditor.getDocument().insertString(offset, issue.toString(), null);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read external issues for " + ScannerReportViewerApp.getNodeName(component), e);
        }
    }

    private void updateCoverage(ScannerReport.Component component) {
        this.coverageEditor.setText("");
        try (CloseableIterator<ScannerReport.LineCoverage> it = this.reader.readComponentCoverage(component.getRef());){
            while (it.hasNext()) {
                ScannerReport.LineCoverage coverage = (ScannerReport.LineCoverage)it.next();
                this.coverageEditor.getDocument().insertString(this.coverageEditor.getDocument().getLength(), coverage + "\n", null);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read code coverage for " + ScannerReportViewerApp.getNodeName(component), e);
        }
    }

    private void updateSource(ScannerReport.Component component) {
        File sourceFile = this.reader.getFileStructure().fileFor(FileStructure.Domain.SOURCE, component.getRef());
        this.sourceEditor.setText("");
        if (sourceFile.exists()) {
            try (Scanner s = new Scanner(sourceFile, StandardCharsets.UTF_8.name()).useDelimiter("\\Z");){
                if (s.hasNext()) {
                    this.sourceEditor.setText(s.next());
                }
            }
            catch (IOException ex) {
                StringWriter errors = new StringWriter();
                ex.printStackTrace(new PrintWriter(errors));
                this.sourceEditor.setText(errors.toString());
            }
        }
    }

    private void updateMetadata() {
        this.metadataEditor.setText("");
        StringBuilder builder = new StringBuilder();
        ScannerReport.Metadata data = this.reader.readMetadata();
        builder.append("Project key: ").append(data.getProjectKey()).append("\n");
        builder.append("Project version: ").append(data.getProjectVersion()).append("\n");
        builder.append("Scm revision ID: ").append(data.getScmRevisionId()).append("\n");
        if (data.getNotAnalyzedFilesByLanguageCount() > 0) {
            builder.append("Not analyzed files in project:").append("\n");
            data.getNotAnalyzedFilesByLanguageMap().forEach((key, value) -> builder.append("   ").append((String)key).append(": ").append(value).append("\n"));
        }
        this.metadataEditor.setText(builder.toString());
    }

    private void updateActiveRules() {
        this.activeRuleEditor.setText("");
        StringBuilder builder = new StringBuilder();
        try (CloseableIterator<ScannerReport.ActiveRule> activeRuleCloseableIterator = this.reader.readActiveRules();){
            while (activeRuleCloseableIterator.hasNext()) {
                builder.append(((ScannerReport.ActiveRule)activeRuleCloseableIterator.next()).toString()).append("\n");
            }
            this.activeRuleEditor.setText(builder.toString());
        }
    }

    private void updateAdHocRules() {
        this.adHocRuleEditor.setText("");
        StringBuilder builder = new StringBuilder();
        try (CloseableIterator<ScannerReport.AdHocRule> adHocRuleCloseableIterator = this.reader.readAdHocRules();){
            while (adHocRuleCloseableIterator.hasNext()) {
                builder.append(((ScannerReport.AdHocRule)adHocRuleCloseableIterator.next()).toString()).append("\n");
            }
            this.adHocRuleEditor.setText(builder.toString());
        }
    }

    private void updateQualityProfiles() {
        this.qualityProfileEditor.setText("");
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, ScannerReport.Metadata.QProfile> qp : this.metadata.getQprofilesPerLanguage().entrySet()) {
            builder.append(qp.getKey()).append(":\n").append(qp.getValue()).append("\n\n");
        }
        this.qualityProfileEditor.setText(builder.toString());
    }

    private void updatePlugins() {
        this.pluginEditor.setText("");
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, ScannerReport.Metadata.Plugin> p : this.metadata.getPluginsByKey().entrySet()) {
            builder.append(p.getKey()).append(":\n").append(p.getValue()).append("\n\n");
        }
        this.pluginEditor.setText(builder.toString());
    }

    private void updateHighlighting(ScannerReport.Component component) {
        this.highlightingEditor.setText("");
        try (CloseableIterator<ScannerReport.SyntaxHighlightingRule> it = this.reader.readComponentSyntaxHighlighting(component.getRef());){
            while (it.hasNext()) {
                ScannerReport.SyntaxHighlightingRule rule = (ScannerReport.SyntaxHighlightingRule)it.next();
                int offset = this.highlightingEditor.getDocument().getLength();
                this.highlightingEditor.getDocument().insertString(offset, rule + "\n", null);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read syntax highlighting for " + ScannerReportViewerApp.getNodeName(component), e);
        }
    }

    private void updateMeasures(ScannerReport.Component component) {
        this.measuresEditor.setText("");
        try (CloseableIterator<ScannerReport.Measure> it = this.reader.readComponentMeasures(component.getRef());){
            while (it.hasNext()) {
                ScannerReport.Measure measure = (ScannerReport.Measure)it.next();
                this.measuresEditor.getDocument().insertString(this.measuresEditor.getDocument().getLength(), measure + "\n", null);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read measures for " + ScannerReportViewerApp.getNodeName(component), e);
        }
    }

    private void updateScm(ScannerReport.Component component) {
        this.scmEditor.setText("");
        ScannerReport.Changesets changesets = this.reader.readChangesets(component.getRef());
        if (changesets == null) {
            return;
        }
        List<Integer> changesetIndexByLine = changesets.getChangesetIndexByLineList();
        try {
            int index = 0;
            for (ScannerReport.Changesets.Changeset changeset : changesets.getChangesetList()) {
                this.scmEditor.getDocument().insertString(this.scmEditor.getDocument().getLength(), index + "\n", null);
                this.scmEditor.getDocument().insertString(this.scmEditor.getDocument().getLength(), changeset + "\n", null);
                ++index;
            }
            this.scmEditor.getDocument().insertString(this.scmEditor.getDocument().getLength(), "\n", null);
            int line = 1;
            for (Integer idx : changesetIndexByLine) {
                this.scmEditor.getDocument().insertString(this.scmEditor.getDocument().getLength(), line + ": " + idx + "\n", null);
                ++line;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read SCM for " + ScannerReportViewerApp.getNodeName(component), e);
        }
    }

    private void updateSymbols(ScannerReport.Component component) {
        this.symbolEditor.setText("");
        try (CloseableIterator<ScannerReport.Symbol> it = this.reader.readComponentSymbols(component.getRef());){
            while (it.hasNext()) {
                ScannerReport.Symbol symbol = (ScannerReport.Symbol)it.next();
                this.symbolEditor.getDocument().insertString(this.symbolEditor.getDocument().getLength(), symbol + "\n", null);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read symbol references for " + ScannerReportViewerApp.getNodeName(component), e);
        }
    }

    private void initialize() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(3);
        this.splitPane = new JSplitPane();
        this.frame.getContentPane().add((Component)this.splitPane, "Center");
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setPreferredSize(new Dimension(500, 7));
        this.splitPane.setRightComponent(this.tabbedPane);
        this.componentDetailsTab = new JScrollPane();
        this.tabbedPane.addTab("Component details", null, this.componentDetailsTab, null);
        this.componentEditor = new JEditorPane();
        this.componentDetailsTab.setViewportView(this.componentEditor);
        this.sourceTab = new JScrollPane();
        this.tabbedPane.addTab("Source", null, this.sourceTab, null);
        this.sourceEditor = ScannerReportViewerApp.createSourceEditor();
        this.sourceEditor.setEditable(false);
        this.sourceTab.setViewportView(this.sourceEditor);
        this.textLineNumber = this.createTextLineNumber();
        this.sourceTab.setRowHeaderView(this.textLineNumber);
        this.highlightingTab = new JScrollPane();
        this.tabbedPane.addTab("Highlighting", null, this.highlightingTab, null);
        this.highlightingEditor = new JEditorPane();
        this.highlightingTab.setViewportView(this.highlightingEditor);
        this.symbolTab = new JScrollPane();
        this.tabbedPane.addTab("Symbol references", null, this.symbolTab, null);
        this.symbolEditor = new JEditorPane();
        this.symbolTab.setViewportView(this.symbolEditor);
        this.coverageTab = new JScrollPane();
        this.tabbedPane.addTab("Coverage", null, this.coverageTab, null);
        this.coverageEditor = new JEditorPane();
        this.coverageTab.setViewportView(this.coverageEditor);
        this.duplicationTab = new JScrollPane();
        this.tabbedPane.addTab("Duplications", null, this.duplicationTab, null);
        this.duplicationEditor = new JEditorPane();
        this.duplicationTab.setViewportView(this.duplicationEditor);
        this.testsTab = new JScrollPane();
        this.tabbedPane.addTab("Tests", null, this.testsTab, null);
        this.testsEditor = new JEditorPane();
        this.testsTab.setViewportView(this.testsEditor);
        this.issuesTab = new JScrollPane();
        this.tabbedPane.addTab("Issues", null, this.issuesTab, null);
        this.issuesEditor = new JEditorPane();
        this.issuesTab.setViewportView(this.issuesEditor);
        this.externalIssuesTab = new JScrollPane();
        this.tabbedPane.addTab("External Issues", null, this.externalIssuesTab, null);
        this.externalIssuesEditor = new JEditorPane();
        this.externalIssuesTab.setViewportView(this.externalIssuesEditor);
        this.measuresTab = new JScrollPane();
        this.tabbedPane.addTab("Measures", null, this.measuresTab, null);
        this.measuresEditor = new JEditorPane();
        this.measuresTab.setViewportView(this.measuresEditor);
        this.scmTab = new JScrollPane();
        this.tabbedPane.addTab("SCM", null, this.scmTab, null);
        this.scmEditor = new JEditorPane();
        this.scmTab.setViewportView(this.scmEditor);
        this.activeRuleTab = new JScrollPane();
        this.tabbedPane.addTab("Active Rules", null, this.activeRuleTab, null);
        this.activeRuleEditor = new JEditorPane();
        this.activeRuleTab.setViewportView(this.activeRuleEditor);
        this.adHocRuleTab = new JScrollPane();
        this.tabbedPane.addTab("Add Hoc Rules", null, this.adHocRuleTab, null);
        this.adHocRuleEditor = new JEditorPane();
        this.adHocRuleTab.setViewportView(this.adHocRuleEditor);
        this.qualityProfileTab = new JScrollPane();
        this.tabbedPane.addTab("Quality Profiles", null, this.qualityProfileTab, null);
        this.qualityProfileEditor = new JEditorPane();
        this.qualityProfileTab.setViewportView(this.qualityProfileEditor);
        this.pluginTab = new JScrollPane();
        this.tabbedPane.addTab("Plugins", null, this.pluginTab, null);
        this.pluginEditor = new JEditorPane();
        this.pluginTab.setViewportView(this.pluginEditor);
        this.cpdTextBlocksTab = new JScrollPane();
        this.tabbedPane.addTab("CPD Text Blocks", null, this.cpdTextBlocksTab, null);
        this.cpdTextBlocksEditor = new JEditorPane();
        this.cpdTextBlocksTab.setViewportView(this.cpdTextBlocksEditor);
        this.significantCodeTab = new JScrollPane();
        this.tabbedPane.addTab("Significant Code Ranges", null, this.significantCodeTab, null);
        this.significantCodeEditor = new JEditorPane();
        this.significantCodeTab.setViewportView(this.significantCodeEditor);
        this.metadataTab = new JScrollPane();
        this.tabbedPane.addTab("Metadata", null, this.metadataTab, null);
        this.metadataEditor = new JEditorPane();
        this.metadataTab.setViewportView(this.metadataEditor);
        this.treeScrollPane = new JScrollPane();
        this.treeScrollPane.setPreferredSize(new Dimension(200, 400));
        this.splitPane.setLeftComponent(this.treeScrollPane);
        this.componentTree = new JTree();
        this.componentTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("empty"){}));
        this.treeScrollPane.setViewportView(this.componentTree);
        this.componentTree.getSelectionModel().setSelectionMode(1);
        this.componentTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ScannerReportViewerApp.this.componentTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                ScannerReportViewerApp.this.frame.setCursor(new Cursor(3));
                ScannerReportViewerApp.this.updateDetails((ScannerReport.Component)node.getUserObject());
                ScannerReportViewerApp.this.frame.setCursor(new Cursor(0));
            }
        });
        this.frame.pack();
    }

    public JTree getComponentTree() {
        return this.componentTree;
    }

    protected JEditorPane getComponentEditor() {
        return this.componentEditor;
    }

    public static JEditorPane createSourceEditor() {
        return new JEditorPane();
    }

    public TextLineNumber createTextLineNumber() {
        return new TextLineNumber(this.sourceEditor);
    }
}

