/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.junit.Assert;
import org.sonar.test.JsonAssert;

public class EventAssert {
    private static final String EVENT = "event";
    private static final String DATA = "data";
    private static final String ID = "id";
    private static final String RETRY = "retry";
    private static final Set<String> ALLOWED_FIELDS = new HashSet<String>(Arrays.asList("event", "data", "id", "retry"));
    private final String eventPayload;

    private EventAssert(String eventPayload) {
        this.eventPayload = eventPayload;
    }

    public static EventAssert assertThatEvent(String eventPayload) {
        return new EventAssert(eventPayload);
    }

    public EventAssert isValid() {
        this.extractFields();
        return this;
    }

    public EventAssert hasField(String name) {
        this.isValid();
        if (!this.extractFields().containsKey(name)) {
            Assert.fail((String)("Expected event to contain field '" + name + "'. Actual event was: '" + this.eventPayload + "'"));
        }
        return this;
    }

    public EventAssert hasType(String value) {
        return this.hasField(EVENT, value);
    }

    public EventAssert hasData(String value) {
        return this.hasField(DATA, value);
    }

    public EventAssert hasField(String name, String value) {
        this.isValid();
        this.hasField(name);
        String actual = this.extractFields().get(name);
        if (!Objects.equals(actual, value)) {
            Assert.fail((String)("Expected field '" + name + "' to contain '" + value + "' but was '" + actual + "'"));
        }
        return this;
    }

    public EventAssert hasJsonData(URL url) {
        this.isValid();
        this.hasField(DATA);
        JsonAssert.assertJson(this.extractFields().get(DATA)).withStrictArrayOrder().isSimilarTo(url);
        return this;
    }

    private Map<String, String> extractFields() {
        HashMap<String, String> fields = new HashMap<String, String>();
        Arrays.stream(this.eventPayload.split("\n")).forEach(line -> {
            String trimmed = line.trim();
            if (!trimmed.isEmpty()) {
                int fieldDelimiterIndex = line.indexOf(58);
                if (fieldDelimiterIndex != -1) {
                    String fieldName = line.substring(0, fieldDelimiterIndex);
                    if (!ALLOWED_FIELDS.contains(fieldName)) {
                        Assert.fail((String)("Unknown field in event: '" + fieldName + "'"));
                    }
                    fields.put(fieldName, line.substring(fieldDelimiterIndex + 1).trim());
                } else {
                    Assert.fail((String)("Invalid line in event: '" + line + "'"));
                }
            }
        });
        return fields;
    }
}

