/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@ThreadSafe
class JsonComparison {
    private boolean strictTimezone = false;
    private boolean strictArrayOrder = false;
    private Set<String> ignoredFields = Collections.synchronizedSet(new HashSet());

    JsonComparison() {
    }

    boolean isStrictTimezone() {
        return this.strictTimezone;
    }

    JsonComparison withTimezone() {
        this.strictTimezone = true;
        return this;
    }

    boolean isStrictArrayOrder() {
        return this.strictArrayOrder;
    }

    JsonComparison withStrictArrayOrder() {
        this.strictArrayOrder = true;
        return this;
    }

    JsonComparison setIgnoredFields(String ... ignoredFields) {
        Collections.addAll(this.ignoredFields, ignoredFields);
        return this;
    }

    boolean areSimilar(String expected, String actual) {
        Object expectedJson = JsonComparison.parse(expected);
        Object actualJson = JsonComparison.parse(actual);
        return this.compare(expectedJson, actualJson);
    }

    private static Object parse(String s) {
        try {
            JSONParser parser = new JSONParser();
            return parser.parse(s);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid JSON: " + s, e);
        }
    }

    private boolean compare(@Nullable Object expectedObject, @Nullable Object actualObject) {
        if (expectedObject == null) {
            return actualObject == null;
        }
        if (actualObject == null) {
            return false;
        }
        if (expectedObject.getClass() != actualObject.getClass()) {
            return false;
        }
        if (expectedObject instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)expectedObject;
            return this.compareArrays(jsonArray, (JSONArray)actualObject);
        }
        if (expectedObject instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)expectedObject;
            return this.compareObjects(jsonObject, (JSONObject)actualObject);
        }
        if (expectedObject instanceof String) {
            String string = (String)expectedObject;
            return this.compareStrings(string, (String)actualObject);
        }
        if (expectedObject instanceof Number) {
            Number number = (Number)expectedObject;
            return JsonComparison.compareNumbers(number, (Number)actualObject);
        }
        return JsonComparison.compareBooleans((Boolean)expectedObject, (Boolean)actualObject);
    }

    private static boolean compareBooleans(Boolean expected, Boolean actual) {
        return expected.equals(actual);
    }

    private static boolean compareNumbers(Number expected, Number actual) {
        double d2;
        double d1 = expected.doubleValue();
        if (Double.compare(d1, d2 = actual.doubleValue()) == 0) {
            return true;
        }
        return Math.abs(d1 - d2) <= 1.0E-7;
    }

    private boolean compareStrings(String expected, String actual) {
        if (!this.strictTimezone) {
            Date expectedDate = JsonComparison.tryParseDate(expected);
            Date actualDate = JsonComparison.tryParseDate(actual);
            if (expectedDate != null && actualDate != null) {
                return expectedDate.getTime() == actualDate.getTime();
            }
        }
        return expected.equals(actual);
    }

    private boolean compareArrays(JSONArray expected, JSONArray actual) {
        if (this.strictArrayOrder) {
            return this.compareArraysByStrictOrder(expected, actual);
        }
        return this.compareArraysByLenientOrder(expected, actual);
    }

    private boolean compareArraysByStrictOrder(JSONArray expected, JSONArray actual) {
        if (expected.size() != actual.size()) {
            return false;
        }
        for (int index = 0; index < expected.size(); ++index) {
            Object actualElt;
            Object expectedElt = expected.get(index);
            if (this.compare(expectedElt, actualElt = actual.get(index))) continue;
            return false;
        }
        return true;
    }

    private boolean compareArraysByLenientOrder(JSONArray expected, JSONArray actual) {
        if (expected.size() > actual.size()) {
            return false;
        }
        ArrayList remainingActual = new ArrayList(actual);
        for (Object expectedElement : expected) {
            boolean found = false;
            for (Object actualElement : remainingActual) {
                if (!this.compare(expectedElement, actualElement)) continue;
                found = true;
                remainingActual.remove(actualElement);
                break;
            }
            if (found) continue;
            return false;
        }
        return remainingActual.isEmpty();
    }

    private boolean compareObjects(JSONObject expectedMap, JSONObject actualMap) {
        for (Map.Entry expectedEntry : expectedMap.entrySet()) {
            Object key = expectedEntry.getKey();
            if (this.shouldIgnoreField(key)) continue;
            if (!actualMap.containsKey(key)) {
                return false;
            }
            if (this.compare(expectedEntry.getValue(), actualMap.get(key))) continue;
            return false;
        }
        return true;
    }

    private boolean shouldIgnoreField(Object key) {
        return key instanceof String && this.ignoredFields.contains(key);
    }

    @CheckForNull
    private static Date tryParseDate(String s) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(s);
        }
        catch (ParseException ignored) {
            return null;
        }
    }
}

